/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.table.filters;

import com.vlsolutions.swing.table.VLJTableFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegExpFilter
implements VLJTableFilter {
    String expression;
    boolean ignoreCase = false;
    Pattern pattern;
    boolean hasPattern;

    public RegExpFilter() {
    }

    public RegExpFilter(boolean ignoreCase) {
        this.setIgnoreCase(ignoreCase);
    }

    public void setFilter(String filter) {
        this.expression = filter;
    }

    public String getFilter() {
        return this.expression;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public boolean accept(Object filterPattern) {
        if (!this.hasPattern) {
            return true;
        }
        if (this.ignoreCase) {
            Matcher m = this.pattern.matcher(((String)filterPattern).toLowerCase());
            return m.matches();
        }
        Matcher m = this.pattern.matcher((String)filterPattern);
        return m.matches();
    }

    @Override
    public void compile() {
        if (this.expression == null || this.expression.equals("")) {
            this.hasPattern = false;
            return;
        }
        this.hasPattern = true;
        String filter = this.expression;
        if (this.ignoreCase) {
            filter = filter.toLowerCase();
        }
        StringBuffer sb = new StringBuffer();
        filter = filter.replace('?', '.');
        boolean foundRegExp = false;
        for (int i = 0; i < filter.length(); ++i) {
            char c = filter.charAt(i);
            if (c == '*') {
                sb.append(".*");
                foundRegExp = true;
                continue;
            }
            if (c == '?') {
                sb.append('.');
                foundRegExp = true;
                continue;
            }
            sb.append(c);
        }
        if (!foundRegExp) {
            sb.append(".*");
        }
        try {
            this.pattern = Pattern.compile(sb.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setFilter(Object value) {
        this.setFilter((String)value);
    }

    @Override
    public boolean isFiltering() {
        return this.expression != null && !this.expression.equals("");
    }
}

