/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.table;

import com.vlsolutions.swing.table.FilterCellEditor;
import com.vlsolutions.swing.table.FilterColumnModel;
import com.vlsolutions.swing.table.FilterModel;
import com.vlsolutions.swing.table.PopUpSelector;
import com.vlsolutions.swing.table.VLJTableFilter;
import com.vlsolutions.swing.table.VLTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class VLJTable
extends JTable {
    private static Image defaultAscImage;
    private static Image defaultDescImage;
    private Image ascendingSortImage;
    private Image descendingSortImage;
    private boolean isFilterHeaderDisplayed = false;
    private boolean isFilteringEnabled = false;
    private boolean isSortEnabled = true;
    private PopUpSelector popupSelector;
    private KeyListener popupSelectorKeyListener;
    private JPanel tableHeaderReplacement;
    private FilterColumnModel filterColumnModel;
    private boolean isFilterRequestingFocus = true;
    private JPanel filterSubHeader;

    public VLJTable() {
        this.setAscendingSortImage(defaultAscImage);
        this.setDescendingSortImage(defaultDescImage);
    }

    public void setFilterColumnModel(FilterColumnModel fcmodel) {
        this.filterColumnModel = fcmodel;
        if (this.isFilterHeaderDisplayed) {
            this.setFilterHeaderVisible(false);
        }
    }

    public FilterColumnModel getFilterColumnModel() {
        return this.filterColumnModel;
    }

    public void setAscendingSortImage(Image image) {
        this.ascendingSortImage = image;
    }

    public void setDescendingSortImage(Image image) {
        this.descendingSortImage = image;
    }

    public Image getAscendingSortImage() {
        return this.ascendingSortImage;
    }

    public Image getDescendingSortImage() {
        return this.descendingSortImage;
    }

    public void setFilteringEnabled(boolean enable) {
        JTableHeader th;
        this.isFilteringEnabled = enable;
        FilterModel fm = (FilterModel)this.getModel();
        if (fm != null) {
            fm.rebuildIndex();
        }
        if ((th = this.getTableHeader()) != null) {
            th.repaint();
        }
    }

    public boolean isFilteringEnabled() {
        return this.isFilteringEnabled;
    }

    public void setSortEnabled(boolean enable) {
        JTableHeader th;
        this.isSortEnabled = enable;
        FilterModel fm = (FilterModel)this.getModel();
        if (fm != null) {
            fm.rebuildIndex();
        }
        if ((th = this.getTableHeader()) != null) {
            th.repaint();
        }
    }

    public boolean isSortEnabled() {
        return this.isSortEnabled;
    }

    public void setFilterHeaderVisible(boolean visible) {
        this.setFilterHeaderVisible(visible, true);
    }

    public void setFilterHeaderVisible(boolean visible, boolean requestFocus) {
        if (visible) {
            this.isFilterRequestingFocus = requestFocus;
            this.installFilterHeader();
        } else {
            this.uninstallFilterHeader();
        }
    }

    public boolean isFilterHeaderVisible() {
        return this.isFilterHeaderDisplayed;
    }

    public boolean isFilterRequestingFocus() {
        return this.isFilterRequestingFocus;
    }

    public void setPopUpSelectorEnabled(boolean enabled) {
        if (this.popupSelectorKeyListener != null) {
            this.removeKeyListener(this.popupSelectorKeyListener);
        }
        if (enabled) {
            this.popupSelectorKeyListener = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    VLJTable.this.processTableKeyEvent(e);
                }
            };
            this.addKeyListener(this.popupSelectorKeyListener);
        }
    }

    public PopUpSelector getPopUpSelector() {
        if (this.popupSelector == null) {
            this.popupSelector = this.createPopUpSelector();
        }
        return this.popupSelector;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && VLJTable.this.isSortEnabled) {
                    TableColumnModel columnModel = VLJTable.this.getColumnModel();
                    int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                    int column = VLJTable.this.convertColumnIndexToModel(viewColumn);
                    int currentSort = VLJTable.this.getSortMode(column);
                    if (currentSort == 0) {
                        VLJTable.this.setSortMode(column, 1);
                    } else if (currentSort == 1) {
                        VLJTable.this.setSortMode(column, 2);
                    } else {
                        VLJTable.this.setSortMode(column, 0);
                    }
                }
            }
        });
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        if (e.getFirstRow() == -1) {
            FilterModel fModel = (FilterModel)this.getModel();
            TableModel model = fModel.getModel();
            for (int i = 0; i < model.getColumnCount(); ++i) {
                this.getColumnModel().getColumn(i).setHeaderRenderer(new VLTableCellRenderer(this, i));
            }
            boolean isFilterDisplayed = this.isFilterHeaderDisplayed;
            this.setFilterColumnModel(new FilterColumnModel(fModel));
            if (isFilterDisplayed) {
                this.installFilterHeader();
            } else {
                this.installHeader();
            }
        }
    }

    @Override
    public void setModel(TableModel model) {
        FilterModel fModel = new FilterModel(this, model);
        super.setModel(fModel);
        for (int i = 0; i < model.getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setHeaderRenderer(new VLTableCellRenderer(this, i));
        }
        this.setFilterColumnModel(new FilterColumnModel(fModel));
        if (this.isFilterHeaderDisplayed) {
            this.installFilterHeader();
        }
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                if (e.getFromIndex() != e.getToIndex() && VLJTable.this.isFilterHeaderDisplayed) {
                    VLJTable.this.reorderFilterHeader();
                }
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                VLJTable.this.adjustFilterSizes();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    public TableModel getBaseModel() {
        return ((FilterModel)this.getModel()).getModel();
    }

    public int getBaseRow(int row) {
        return ((FilterModel)this.getModel()).getSourceRow(row);
    }

    public void setFilterValue(int col, Object value) {
        if (this.filterColumnModel != null && this.isFilterHeaderDisplayed) {
            this.filterColumnModel.getFilterCellEditor(col).setValue(value);
        } else {
            ((FilterModel)this.getModel()).setFilter(col, value);
            Rectangle r = this.getCellRect(0, 0, false);
            this.scrollRectToVisible(r);
        }
    }

    public VLJTableFilter getFilter(int col) {
        return ((FilterModel)this.getModel()).getFilter(col);
    }

    public void setSortMode(int col, int mode) {
        this.isSortEnabled = true;
        ((FilterModel)this.getModel()).setSortMode(col, mode);
        this.getTableHeader().repaint();
    }

    public int getSortMode(int col) {
        return ((FilterModel)this.getModel()).getSortMode(col);
    }

    public void installFilter(int col, VLJTableFilter filter) {
        ((FilterModel)this.getModel()).installFilter(col, filter);
    }

    public void selectFirstRowLike(int col, String text, boolean isCaseSensitive) {
        int idx = -1;
        for (int i = 0; i < this.getRowCount(); ++i) {
            int compare;
            StringBuffer sb = new StringBuffer();
            sb.append(this.getValueAt(i, col).toString());
            int colAppend = col + 1;
            int len = text.length();
            while (sb.length() < len && colAppend < this.getModel().getColumnCount()) {
                sb.append(this.getValueAt(i, colAppend++).toString());
            }
            String str = sb.toString();
            int n = compare = isCaseSensitive ? str.compareTo(text) : str.compareToIgnoreCase(text);
            if (compare < 0) continue;
            idx = i;
            break;
        }
        if (idx != -1) {
            this.setRowSelectionInterval(idx, idx);
            this.scrollRectToVisible(this.getCellRect(idx, col, true));
        } else {
            this.clearSelection();
        }
    }

    protected PopUpSelector createPopUpSelector() {
        return new PopUpSelector(this);
    }

    protected void reorderFilterHeader() {
        this.filterSubHeader.removeAll();
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            int col = this.getColumnModel().getColumn(i).getModelIndex();
            FilterCellEditor fcEditor = this.filterColumnModel.getFilterCellEditor(col);
            JComponent tfComp = fcEditor != null ? (JComponent)((Object)fcEditor) : new JLabel();
            this.filterSubHeader.add(tfComp);
        }
        this.adjustFilterSizes();
    }

    protected void adjustFilterSizes() {
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            Component comp = this.filterSubHeader.getComponent(i);
            int w = this.getColumnModel().getColumn(i).getWidth();
            Dimension d = new Dimension(w, comp.getPreferredSize().height);
            comp.setPreferredSize(d);
        }
        this.filterSubHeader.revalidate();
    }

    protected void installFilterHeader() {
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            JPanel newHeader = new JPanel(new BorderLayout());
            newHeader.add((Component)this.getTableHeader(), "Center");
            this.filterSubHeader = new JPanel(new FlowLayout(0, 0, 0));
            this.filterSubHeader.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black), BorderFactory.createEmptyBorder(1, 0, 0, 0)));
            FilterCellEditor firstFilter = null;
            for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
                JComponent tfComp;
                FilterCellEditor fcEditor = this.filterColumnModel.getFilterCellEditor(i);
                if (fcEditor != null) {
                    fcEditor.setValue(null);
                }
                JComponent jComponent = tfComp = fcEditor != null ? (JComponent)((Object)fcEditor) : new JLabel();
                if (firstFilter == null) {
                    firstFilter = fcEditor;
                }
                final int col = i;
                int w = this.getColumnModel().getColumn(col).getWidth();
                Dimension d = new Dimension(w, tfComp.getPreferredSize().height);
                tfComp.setPreferredSize(d);
                this.filterSubHeader.add(tfComp);
                if (fcEditor == null) continue;
                fcEditor.addPropertyChangeListener(fcEditor.getFilterChangePropertyName(), new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        ((FilterModel)VLJTable.this.getModel()).setFilter(col, e.getNewValue());
                        Rectangle r = VLJTable.this.getCellRect(0, 0, false);
                        VLJTable.this.scrollRectToVisible(r);
                    }
                });
            }
            newHeader.add((Component)this.filterSubHeader, "South");
            this.tableHeaderReplacement = newHeader;
            this.installHeader();
            if (firstFilter != null && this.isFilterRequestingFocus) {
                final JComponent filter = (JComponent)((Object)firstFilter);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        filter.requestFocus();
                    }
                });
            }
        }
        this.isFilterHeaderDisplayed = true;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        if (this.isFilterHeaderDisplayed) {
            JScrollPane scrollPane;
            Border border;
            Container gp;
            Container p = this.getParent();
            if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane && ((border = (scrollPane = (JScrollPane)gp).getBorder()) == null || border instanceof UIResource)) {
                scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
        } else {
            super.configureEnclosingScrollPane();
        }
    }

    protected void installHeader() {
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            JScrollPane enclosingScrollPane = (JScrollPane)parent.getParent();
            if (this.tableHeaderReplacement == null) {
                enclosingScrollPane.setColumnHeaderView(this.getTableHeader());
            } else {
                enclosingScrollPane.setColumnHeaderView(this.tableHeaderReplacement);
            }
        }
    }

    private void processTableKeyEvent(KeyEvent e) {
        int col = this.getSelectedColumn();
        int row = this.getSelectedRow();
        if (col == -1) {
            col = 0;
        }
        if (row == -1) {
            row = 0;
        }
        if (this.getModel().isCellEditable(row, col)) {
            return;
        }
        if (Character.isLetterOrDigit(e.getKeyChar())) {
            if (this.popupSelector == null) {
                this.popupSelector = this.createPopUpSelector();
                this.popupSelector.setCol(col);
            } else {
                this.popupSelector.setCol(col);
            }
            this.popupSelector.setText(String.valueOf(e.getKeyChar()));
            this.popupSelector.popUp();
        }
    }

    private void uninstallFilterHeader() {
        this.tableHeaderReplacement = null;
        this.installHeader();
        ((FilterModel)this.getModel()).clearFilters();
        this.isFilterHeaderDisplayed = false;
    }

    static {
        try {
            defaultAscImage = new ImageIcon(VLJTable.class.getResource("sortAsc16.png")).getImage();
            defaultDescImage = new ImageIcon(VLJTable.class.getResource("sortDsc16.png")).getImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

