/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.table;

import com.vlsolutions.swing.table.VLJTable;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class PopUpSelector
extends JPopupMenu
implements KeyListener,
DocumentListener,
FocusListener,
ActionListener {
    protected JTextField textField = new JTextField(10);
    protected int col;
    protected JLabel columnLabel = new JLabel();
    protected VLJTable table;
    protected boolean isCaseSensitive = false;
    protected JPanel panel = new JPanel(new FlowLayout());

    public PopUpSelector(VLJTable table) {
        this.col = this.col;
        this.table = table;
        this.textField.setOpaque(false);
        this.textField.addKeyListener(this);
        this.textField.addFocusListener(this);
        this.textField.addActionListener(this);
        this.textField.getDocument().addDocumentListener(this);
        this.panel.add(this.columnLabel);
        this.panel.add(this.textField);
        this.panel.setBackground(this.getBackground().brighter());
        this.add(this.panel);
        this.setBorderPainted(true);
        this.setInvoker(table);
        this.pack();
    }

    public PopUpSelector(VLJTable table, int col) {
        this(table);
        this.setCol(col);
    }

    public void setCol(int col) {
        this.col = col;
        this.columnLabel.setText(this.table.getModel().getColumnName(col));
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 9 || e.getKeyCode() == 27) {
            this.returnToTable();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.returnToTable();
    }

    public void returnToTable() {
        this.setVisible(false);
        this.table.requestFocus();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 10) {
            this.returnToTable();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.setVisible(false);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateSelection(e.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateSelection(e.getDocument());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateSelection(e.getDocument());
    }

    private void updateSelection(Document d) {
        try {
            this.table.selectFirstRowLike(this.col, d.getText(0, d.getLength()), this.isCaseSensitive);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public String getText() {
        return this.textField.getText();
    }

    public void popUp() {
        Insets i = this.getInsets();
        int h = this.panel.getPreferredSize().height + i.top + i.bottom;
        if (this.table.getParent() instanceof JViewport) {
            this.show(this.table.getParent(), 0, -h);
        } else {
            this.show(this.table, 0, -h);
        }
        this.textField.requestFocus();
    }
}

