/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.xmlgui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;

public class DesktopManager
extends JTabbedPane {
    private static final long serialVersionUID = 487990680719191308L;
    private MoveInternalFramePopup moveToDesktopPopup;
    private PopupListener popupListener;
    private ArrayList<String> desktopList = new ArrayList();

    public DesktopManager() {
        this.moveToDesktopPopup = new MoveInternalFramePopup();
        this.popupListener = new PopupListener();
    }

    public void addDesktop(String deskName) {
        this.addTab(deskName, new JScrollPane(new JDesktopPane()));
        this.desktopList.add(deskName);
    }

    public void removeDesktop(String deskName) {
        this.removeTabAt(this.indexOfTab(deskName));
        this.desktopList.remove(deskName);
    }

    public JDesktopPane getCurrentDesktop() {
        return this.getDesktopFromTabContent(this.getSelectedComponent());
    }

    public JDesktopPane getDesktop(String deskName) {
        return this.getDesktopFromTabContent(this.getComponentAt(this.indexOfTab(deskName)));
    }

    public JDesktopPane getDesktop(int index) {
        return this.getDesktopFromTabContent(this.getComponentAt(index));
    }

    public JInternalFrame createMultiDesktopInternalFrame(String title, boolean resizable, boolean closeable, boolean maximizable, boolean iconifiable) {
        JInternalFrame internalFrame = new JInternalFrame(title, resizable, closeable, maximizable, iconifiable);
        internalFrame.addMouseListener(this.popupListener);
        return internalFrame;
    }

    public ArrayList<String> getDesktopNameList() {
        return this.desktopList;
    }

    private JDesktopPane getDesktopFromTabContent(Component tabContent) {
        return (JDesktopPane)((JViewport)((JScrollPane)tabContent).getComponent(0)).getComponent(0);
    }

    private class MoveInternalFramePopup
    extends JPopupMenu
    implements ActionListener {
        private static final long serialVersionUID = 1635335641054074108L;
        private JInternalFrame currentFrame;
        private ArrayList<String> desktopList;

        public MoveInternalFramePopup() {
            this.desktopList = (ArrayList)DesktopManager.this.getDesktopNameList().clone();
            this.loadDesktopList();
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.loadDesktopList();
            super.show(invoker, x, y);
        }

        public void setInternalFrame(JInternalFrame currentFrame) {
            this.currentFrame = currentFrame;
        }

        private void loadDesktopList() {
            if (!this.desktopList.equals(DesktopManager.this.getDesktopNameList())) {
                this.desktopList = (ArrayList)DesktopManager.this.getDesktopNameList().clone();
                this.removeAll();
                Iterator<String> i = DesktopManager.this.getDesktopNameList().iterator();
                while (i.hasNext()) {
                    JMenuItem item = new JMenuItem(i.next());
                    item.addActionListener(this);
                    this.add(item);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DesktopManager.this.getDesktop(this.desktopList.indexOf(e.getActionCommand())).equals(this.currentFrame.getDesktopPane())) {
                return;
            }
            JDesktopPane oldDesk = this.currentFrame.getDesktopPane();
            DesktopManager.this.getDesktop(this.desktopList.indexOf(e.getActionCommand())).add(this.currentFrame);
            this.currentFrame.getDesktopPane().validate();
            this.currentFrame.getDesktopPane().repaint();
            try {
                this.currentFrame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            oldDesk.repaint();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DesktopManager.this.moveToDesktopPopup.setInternalFrame((JInternalFrame)e.getComponent());
                DesktopManager.this.moveToDesktopPopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

