/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.file;

import com.artenum.tk.ui.api.FileListener;
import com.artenum.tk.ui.api.FileValue;
import com.artenum.tk.ui.util.ObjectConvertor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SingleFileInput
implements FileValue,
ActionListener {
    private static final Dimension MIN_SIZE = new Dimension(100, 20);
    private static final Dimension MAX_SIZE = new Dimension(1024, 20);
    private ArrayList<FileListener> listeners = new ArrayList();
    private JPanel ui;
    private JTextField filePath = new JTextField();
    private JLabel fileSize;
    private JButton browse;
    private JFileChooser chooser;

    public SingleFileInput() {
        this.filePath.addActionListener(this);
        this.fileSize = new JLabel();
        this.browse = new JButton("Parcourir");
        this.browse.addActionListener(this);
        this.ui = new JPanel();
        this.ui.setOpaque(false);
        this.ui.setLayout(new BoxLayout(this.ui, 0));
        this.ui.add(this.filePath);
        this.ui.add(Box.createHorizontalStrut(5));
        this.ui.add(this.browse);
        this.ui.add(Box.createHorizontalStrut(5));
        this.filePath.setMaximumSize(MAX_SIZE);
        this.filePath.setMinimumSize(MIN_SIZE);
        Dimension size = new Dimension(100, 20);
        this.fileSize.setMaximumSize(size);
        this.fileSize.setMinimumSize(size);
        this.fileSize.setPreferredSize(size);
        this.fileSize.setSize(size);
        this.ui.add(this.fileSize);
        this.chooser = new JFileChooser();
    }

    @Override
    public void addFileListener(FileListener l) {
        this.listeners.add(l);
    }

    @Override
    public JComponent getUI() {
        return this.ui;
    }

    @Override
    public String getValue() {
        return this.filePath.getText();
    }

    @Override
    public void notifyListener() {
        String value = this.filePath.getText();
        for (FileListener listener : this.listeners) {
            listener.valueChanged(value);
        }
    }

    @Override
    public void removeFileListener(FileListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setValue(String value, boolean notify) {
        this.filePath.setText(value);
        if (notify) {
            this.notifyListener();
        }
        this.updateFileInfo();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.filePath)) {
            this.updateFileInfo();
        } else if (0 == this.chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this.ui))) {
            this.filePath.setText(this.chooser.getSelectedFile().getAbsolutePath());
        }
        this.updateFileInfo();
    }

    private void updateFileInfo() {
        this.checkFileSize();
        this.notifyListener();
    }

    private void checkFileSize() {
        String fileSizeTxt = ObjectConvertor.convertToFileSizeRepresentation(new File(this.filePath.getText()).length());
        this.filePath.setToolTipText(fileSizeTxt);
        this.fileSize.setText("(".concat(fileSizeTxt).concat(")"));
        this.ui.validate();
        this.ui.repaint();
    }
}

