/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics.Kernels;

import Catalano.Statistics.Kernels.IMercerKernel;

public class Dirichlet
implements IMercerKernel<double[]> {
    private int dimension;

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public Dirichlet(int dimension) {
        this.dimension = dimension;
    }

    @Override
    public double Function(double[] x, double[] y) {
        double prod = 1.0;
        for (int i = 0; i < x.length; ++i) {
            double delta = x[i] - y[i];
            double num = Math.sin(((double)this.dimension + 0.5) * delta);
            double den = 2.0 * Math.sin(delta / 2.0);
            prod *= num / den;
        }
        return prod;
    }
}

