/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Statistics;

import Catalano.Core.FloatRange;

public class ContinuousHistogram {
    private int[] values;
    private FloatRange range;
    private float mean;
    private float stdDev;
    private float median;
    private float min;
    private float max;
    private int total;

    public int[] getValues() {
        return this.values;
    }

    public float getMean() {
        return this.mean;
    }

    public float getStdDev() {
        return this.stdDev;
    }

    public float getMedian() {
        return this.median;
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public ContinuousHistogram(int[] values, FloatRange range) {
        this.values = values;
        this.range = range;
        this.Update();
    }

    public FloatRange getRange(float percent) {
        int max;
        int min;
        int h = (int)((float)this.total * (percent + (1.0f - percent) / 2.0f));
        int n = this.values.length;
        int nM1 = n - 1;
        int hits = this.total;
        for (min = 0; min < n && (hits -= this.values[min]) >= h; ++min) {
        }
        hits = this.total;
        for (max = nM1; max >= 0 && (hits -= this.values[max]) >= h; --max) {
        }
        return new FloatRange((float)min / (float)nM1 * this.range.length() + this.range.getMin(), (float)max / (float)nM1 * this.range.length() + this.range.getMin());
    }

    public void Update() {
        int m;
        int hits;
        int i;
        int n = this.values.length;
        int nM1 = n - 1;
        float rangeLength = this.range.length();
        float rangeMin = this.range.getMin();
        this.max = 0.0f;
        this.min = n;
        this.mean = 0.0f;
        this.stdDev = 0.0f;
        this.total = 0;
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            hits = this.values[i];
            if (hits != 0) {
                if ((float)i > this.max) {
                    this.max = i;
                }
                if ((float)i < this.min) {
                    this.min = i;
                }
            }
            this.total += hits;
            sum += ((double)i / (double)nM1 * (double)rangeLength + (double)rangeMin) * (double)hits;
        }
        if (this.total != 0) {
            this.mean = (float)(sum / (double)this.total);
        }
        this.min = this.min / (float)nM1 * rangeLength + rangeMin;
        this.max = this.max / (float)nM1 * rangeLength + rangeMin;
        sum = 0.0;
        for (i = 0; i < n; ++i) {
            hits = this.values[i];
            double diff = (double)i / (double)nM1 * (double)rangeLength + (double)rangeMin - (double)this.mean;
            sum += diff * diff * (double)hits;
        }
        if (this.total != 0) {
            this.stdDev = (float)Math.sqrt(sum / (double)this.total);
        }
        int halfTotal = this.total / 2;
        hits = 0;
        for (m = 0; m < n && (hits += this.values[m]) < halfTotal; ++m) {
        }
        this.median = (float)m / (float)nM1 * rangeLength + rangeMin;
    }
}

