/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Neuro.ActivationFunction;

import Catalano.Neuro.ActivationFunction.IActivationFunction;

public class SoftExponentialFunction
implements IActivationFunction {
    private double alpha;

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public SoftExponentialFunction() {
        this(0.0);
    }

    public SoftExponentialFunction(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public double Function(double x) {
        if (this.alpha == 0.0) {
            return x;
        }
        if (this.alpha < 0.0) {
            return -Math.log(1.0 - this.alpha * (x + this.alpha)) / this.alpha;
        }
        return (Math.exp(this.alpha * x) - 1.0) / this.alpha + this.alpha;
    }

    @Override
    public double Derivative(double x) {
        if (this.alpha < 0.0) {
            return 1.0 / (1.0 - this.alpha * (this.alpha + x));
        }
        return Math.pow(Math.E, this.alpha * x);
    }

    @Override
    public double Derivative2(double x) {
        return this.Derivative(x);
    }
}

