/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Transforms;

import Catalano.Math.ComplexNumber;
import Catalano.Math.Transforms.FourierTransform;

public class HilbertTransform {
    public static void FHT(double[] data, FourierTransform.Direction direction) {
        int N = data.length;
        if (direction == FourierTransform.Direction.Forward) {
            int i;
            ComplexNumber[] cdata = new ComplexNumber[N];
            for (i = 0; i < N; ++i) {
                cdata[i] = new ComplexNumber(data[i], 0.0);
            }
            FourierTransform.FFT(cdata, FourierTransform.Direction.Forward);
            for (i = 1; i < N / 2; ++i) {
                cdata[i].real *= 2.0;
                cdata[i].imaginary *= 2.0;
            }
            for (i = N / 2 + 1; i < N; ++i) {
                cdata[i].real = 0.0;
                cdata[i].imaginary = 0.0;
            }
            FourierTransform.FFT(cdata, FourierTransform.Direction.Backward);
            for (i = 0; i < N; ++i) {
                data[i] = cdata[i].imaginary;
            }
        } else {
            HilbertTransform.FHT(data, FourierTransform.Direction.Forward);
            for (int i = 0; i < data.length; ++i) {
                data[i] = -data[i];
            }
        }
    }

    public static void FHT(ComplexNumber[] data, FourierTransform.Direction direction) {
        int N = data.length;
        if (direction == FourierTransform.Direction.Forward) {
            int i;
            ComplexNumber[] shift = (ComplexNumber[])data.clone();
            FourierTransform.FFT(shift, FourierTransform.Direction.Backward);
            for (i = 1; i < N / 2; ++i) {
                shift[i].real *= 2.0;
                shift[i].imaginary *= 2.0;
            }
            for (i = N / 2 + 1; i < N; ++i) {
                shift[i].real = 0.0;
                shift[i].imaginary = 0.0;
            }
            FourierTransform.FFT(shift, FourierTransform.Direction.Forward);
            for (i = 0; i < N; ++i) {
                data[i].imaginary = shift[i].imaginary;
            }
        } else {
            for (int i = 0; i < data.length; ++i) {
                data[i].imaginary = 0.0;
            }
        }
    }

    public static void FHT2(ComplexNumber[][] data, FourierTransform.Direction direction) {
        int j;
        int n = data.length;
        int m = data[0].length;
        ComplexNumber[] row = new ComplexNumber[Math.max(m, n)];
        for (int i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                row[j] = data[i][j];
            }
            HilbertTransform.FHT(row, direction);
            for (j = 0; j < n; ++j) {
                data[i][j] = row[j];
            }
        }
        ComplexNumber[] col = new ComplexNumber[n];
        for (j = 0; j < n; ++j) {
            int i;
            for (i = 0; i < n; ++i) {
                col[i] = data[i][j];
            }
            HilbertTransform.FHT(col, direction);
            for (i = 0; i < n; ++i) {
                data[i][j] = col[i];
            }
        }
    }
}

