/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Transforms;

public class DiscreteSineTransform {
    private DiscreteSineTransform() {
    }

    public static void Forward(double[] data) {
        DiscreteSineTransform.Forward(data, 1.0);
    }

    private static void Forward(double[] data, double inverse) {
        double[] result = new double[data.length];
        for (int k = 1; k < result.length + 1; ++k) {
            double sum = 0.0;
            for (int i = 1; i < data.length + 1; ++i) {
                sum += data[i - 1] * Math.sin(Math.PI * ((double)(k * i) / ((double)data.length + 1.0)));
            }
            result[k - 1] = sum * inverse;
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = result[i];
        }
    }

    public static void Backward(double[] data) {
        double inverse = 2.0 / (double)(data.length + 1);
        DiscreteSineTransform.Forward(data, inverse);
    }

    public static void Forward(double[][] data) {
        DiscreteSineTransform.Forward(data, 1.0);
    }

    private static void Forward(double[][] data, double inverse) {
        int rows = data.length;
        int cols = data[0].length;
        double[] row = new double[cols];
        double[] col = new double[rows];
        for (int i = 0; i < rows; ++i) {
            int j;
            for (j = 0; j < row.length; ++j) {
                row[j] = data[i][j];
            }
            DiscreteSineTransform.Forward(row, inverse);
            for (j = 0; j < row.length; ++j) {
                data[i][j] = row[j];
            }
        }
        for (int j = 0; j < cols; ++j) {
            int i;
            for (i = 0; i < col.length; ++i) {
                col[i] = data[i][j];
            }
            DiscreteSineTransform.Forward(col, inverse);
            for (i = 0; i < col.length; ++i) {
                data[i][j] = col[i];
            }
        }
    }

    public static void Backward(double[][] data) {
        double inverse = 2.0 / (double)(data.length + 1);
        DiscreteSineTransform.Forward(data, inverse);
    }
}

