/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math.Random;

import Catalano.Math.Random.IRandomNumberGenerator;

public class MersenneTwister64
implements IRandomNumberGenerator {
    private static final int NN = 312;
    private static final int MM = 156;
    private static final long MATRIX_A = -5403634167711393303L;
    private static final long UM = Integer.MIN_VALUE;
    private static final long LM = Integer.MAX_VALUE;
    private static final long[] mag01 = new long[]{0L, -5403634167711393303L};
    private long[] mt = new long[312];
    private int mti = 313;
    private long bits64;
    private boolean bitState = true;
    private static final long MAGIC_SEED = 777078800230351907L;
    private static final long MAGIC_FACTOR1 = 6364136223846793005L;

    public MersenneTwister64() {
        this(777078800230351907L);
    }

    public MersenneTwister64(long seed) {
        this.setSeed(seed);
    }

    @Override
    public void setSeed(long seed) {
        this.mt[0] = seed;
        this.mti = 1;
        while (this.mti < 312) {
            this.mt[this.mti] = 6364136223846793005L * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 62) + (long)this.mti;
            ++this.mti;
        }
    }

    @Override
    public int nextBits(int numbits) {
        if (this.bitState) {
            this.bits64 = this.nextLong();
            this.bitState = false;
            return (int)(this.bits64 >>> 64 - numbits);
        }
        this.bitState = true;
        return (int)this.bits64 >>> 32 - numbits;
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 1) / 9.223372036854776E18;
    }

    @Override
    public void nextDoubles(double[] d) {
        int n = d.length;
        for (int i = 0; i < n; ++i) {
            d[i] = this.nextDouble();
        }
    }

    @Override
    public int nextInt() {
        return this.nextBits(32);
    }

    @Override
    public int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.nextBits(31) >> 31);
        }
        while ((bits = this.nextBits(31)) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    @Override
    public long nextLong() {
        long x;
        if (this.mti >= 312) {
            int i;
            for (i = 0; i < 156; ++i) {
                x = this.mt[i] & Integer.MIN_VALUE | this.mt[i + 1] & Integer.MAX_VALUE;
                this.mt[i] = this.mt[i + 156] ^ x >>> 1 ^ mag01[(int)(x & 1L)];
            }
            while (i < 311) {
                x = this.mt[i] & Integer.MIN_VALUE | this.mt[i + 1] & Integer.MAX_VALUE;
                this.mt[i] = this.mt[i + -156] ^ x >>> 1 ^ mag01[(int)(x & 1L)];
                ++i;
            }
            x = this.mt[311] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[311] = this.mt[155] ^ x >>> 1 ^ mag01[(int)(x & 1L)];
            this.mti = 0;
        }
        x = this.mt[this.mti++];
        x ^= x >>> 29 & 0x5555555555555555L;
        x ^= x << 17 & 0x71D67FFFEDA60000L;
        x ^= x << 37 & 0xFFF7EEE000000000L;
        x ^= x >>> 43;
        return x;
    }
}

