/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math;

import Catalano.Math.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class PolishExpression {
    private static int LEFT = 0;
    private static int RIGHT = 1;
    private static final Map<String, int[]> OPERATORS = new HashMap<String, int[]>();

    public void AddOperator(String symbol, int precedence, Associativity associativity) {
        switch (associativity) {
            case Left: {
                OPERATORS.put(symbol, new int[]{precedence, 0});
                break;
            }
            case Right: {
                OPERATORS.put(symbol, new int[]{precedence, 1});
            }
        }
    }

    public double Evaluate(String rpn) {
        return this.Evaluate(rpn.split(" "));
    }

    public double Evaluate(String[] rpnTokens) {
        Stack<Double> values = new Stack<Double>();
        double result = 0.0;
        for (int i = 0; i < rpnTokens.length; ++i) {
            if (Tools.isNumeric(rpnTokens[i])) {
                values.push(Double.parseDouble(rpnTokens[i]));
                continue;
            }
            result = PolishExpression.Calc(values, rpnTokens[i]);
        }
        return result;
    }

    private static double Calc(Stack<Double> values, String op) {
        switch (op) {
            case "+": {
                Double a = values.pop();
                Double b = values.pop();
                values.push(b + a);
                return values.peek();
            }
            case "-": {
                Double a = values.pop();
                Double b = values.pop();
                values.push(b - a);
                return values.peek();
            }
            case "*": {
                Double a = values.pop();
                Double b = values.pop();
                values.push(b * a);
                return values.peek();
            }
            case "/": {
                Double a = values.pop();
                Double b = values.pop();
                values.push(b / a);
                return values.peek();
            }
            case "^": {
                Double a = values.pop();
                Double b = values.pop();
                values.push(Math.pow(b, a));
                return values.peek();
            }
            case "pow": {
                Double a = values.pop();
                Double b = values.pop();
                values.push(Math.pow(b, a));
                return values.peek();
            }
            case "ln": {
                Double a = values.pop();
                values.push(Math.log(a));
                return values.peek();
            }
            case "exp": {
                Double a = values.pop();
                values.push(Math.exp(a));
                return values.peek();
            }
            case "sqrt": {
                Double a = values.pop();
                values.push(Math.sqrt(a));
                return values.peek();
            }
            case "sin": {
                Double a = values.pop();
                values.push(Math.sin(a));
                return values.peek();
            }
            case "cos": {
                Double a = values.pop();
                values.push(Math.cos(a));
                return values.peek();
            }
            case "tan": {
                Double a = values.pop();
                values.push(Math.tan(a));
                return values.peek();
            }
        }
        return 0.0;
    }

    public String toReversePolishNotation(String infixNotation) {
        Object[] tokens = this.toReversePolishNotation(infixNotation.split(" "));
        return Arrays.toString(tokens);
    }

    public String[] toReversePolishNotation(String[] inputTokens) {
        ArrayList out = new ArrayList();
        Stack<String> stack = new Stack<String>();
        for (String token : inputTokens) {
            if (PolishExpression.isOperator(token)) {
                while (!stack.empty() && PolishExpression.isOperator((String)stack.peek()) && (PolishExpression.isAssociative(token, LEFT) && PolishExpression.cmpPrecedence(token, (String)stack.peek()) <= 0 || PolishExpression.isAssociative(token, RIGHT) && PolishExpression.cmpPrecedence(token, (String)stack.peek()) < 0)) {
                    out.add(stack.pop());
                }
                stack.push(token);
                continue;
            }
            if (token.equals("(")) {
                stack.push(token);
                continue;
            }
            if (token.equals(")")) {
                while (!stack.empty() && !((String)stack.peek()).equals("(")) {
                    out.add(stack.pop());
                }
                stack.pop();
                continue;
            }
            out.add(token);
        }
        while (!stack.empty()) {
            out.add(stack.pop());
        }
        String[] output = new String[out.size()];
        return out.toArray(output);
    }

    private static boolean isOperator(String token) {
        return OPERATORS.containsKey(token);
    }

    private static boolean isAssociative(String token, int type) {
        if (!PolishExpression.isOperator(token)) {
            throw new IllegalArgumentException("Invalid token: " + token);
        }
        return OPERATORS.get(token)[1] == type;
    }

    private static int cmpPrecedence(String token1, String token2) {
        if (!PolishExpression.isOperator(token1) || !PolishExpression.isOperator(token2)) {
            throw new IllegalArgumentException("Invalied tokens: " + token1 + " " + token2);
        }
        return OPERATORS.get(token1)[0] - OPERATORS.get(token2)[0];
    }

    static {
        OPERATORS.put("+", new int[]{0, LEFT});
        OPERATORS.put("-", new int[]{0, LEFT});
        OPERATORS.put("*", new int[]{1, LEFT});
        OPERATORS.put("/", new int[]{1, LEFT});
        OPERATORS.put("%", new int[]{1, LEFT});
        OPERATORS.put("mod", new int[]{1, LEFT});
        OPERATORS.put("abs", new int[]{1, RIGHT});
        OPERATORS.put("ln", new int[]{1, RIGHT});
        OPERATORS.put("sin", new int[]{1, RIGHT});
        OPERATORS.put("cos", new int[]{1, RIGHT});
        OPERATORS.put("sum", new int[]{1, RIGHT});
        OPERATORS.put("^", new int[]{2, RIGHT});
        OPERATORS.put("pow", new int[]{2, RIGHT});
    }

    public static enum Associativity {
        Left,
        Right;

    }
}

