/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math;

import Catalano.Math.Vector3;

public class Matrix3x3 {
    public float V00;
    public float V01;
    public float V02;
    public float V10;
    public float V11;
    public float V12;
    public float V20;
    public float V21;
    public float V22;

    public Matrix3x3() {
        this.V02 = 0.0f;
        this.V01 = 0.0f;
        this.V00 = 0.0f;
        this.V12 = 0.0f;
        this.V11 = 0.0f;
        this.V10 = 0.0f;
        this.V22 = 0.0f;
        this.V21 = 0.0f;
        this.V22 = 0.0f;
    }

    public Matrix3x3(float V00, float V01, float V02, float V10, float V11, float V12, float V20, float V21, float V22) {
        this.V00 = V00;
        this.V01 = V01;
        this.V02 = V02;
        this.V10 = V10;
        this.V11 = V11;
        this.V12 = V12;
        this.V20 = V20;
        this.V21 = V21;
        this.V22 = V22;
    }

    public static Matrix3x3 Identity() {
        return new Matrix3x3(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public float Determinant() {
        return this.V00 * this.V11 * this.V22 + this.V01 * this.V12 * this.V20 + this.V02 * this.V10 * this.V21 - this.V00 * this.V12 * this.V21 - this.V01 * this.V10 * this.V22 - this.V02 * this.V11 * this.V20;
    }

    public float[] toArray() {
        return new float[]{this.V00, this.V01, this.V02, this.V10, this.V11, this.V12, this.V20, this.V21, this.V22};
    }

    public static Matrix3x3 CreateRotationY(float radians) {
        Matrix3x3 m = new Matrix3x3();
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        m.V00 = m.V22 = cos;
        m.V02 = sin;
        m.V20 = -sin;
        m.V11 = 1.0f;
        return m;
    }

    public static Matrix3x3 CreateRotationX(float radians) {
        Matrix3x3 m = new Matrix3x3();
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        m.V11 = m.V22 = cos;
        m.V12 = -sin;
        m.V21 = sin;
        m.V00 = 1.0f;
        return m;
    }

    public static Matrix3x3 CreateRotationZ(float radians) {
        Matrix3x3 m = new Matrix3x3();
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        m.V00 = m.V11 = cos;
        m.V01 = -sin;
        m.V10 = sin;
        m.V22 = 1.0f;
        return m;
    }

    public static Matrix3x3 CreateFromYawPitchRoll(float yaw, float pitch, float roll) {
        Matrix3x3 r = Matrix3x3.Multiply(Matrix3x3.CreateRotationY(yaw), Matrix3x3.CreateRotationX(pitch));
        r.Multiply(Matrix3x3.CreateRotationZ(roll));
        return r;
    }

    public float[] ExtractYawPitchRoll() {
        float[] v = new float[]{(float)Math.atan2(this.V02, this.V22), (float)Math.asin(-this.V12), (float)Math.atan2(this.V10, this.V11)};
        return v;
    }

    public static Matrix3x3 CreateFromRows(Vector3 row0, Vector3 row1, Vector3 row2) {
        Matrix3x3 m = new Matrix3x3();
        m.V00 = row0.x;
        m.V01 = row0.y;
        m.V02 = row0.z;
        m.V10 = row1.x;
        m.V11 = row1.y;
        m.V12 = row1.z;
        m.V20 = row2.x;
        m.V21 = row2.y;
        m.V22 = row2.z;
        return m;
    }

    public static Matrix3x3 CreateFromColumns(Vector3 column0, Vector3 column1, Vector3 column2) {
        Matrix3x3 m = new Matrix3x3();
        m.V00 = column0.x;
        m.V10 = column0.y;
        m.V20 = column0.z;
        m.V01 = column1.x;
        m.V11 = column1.y;
        m.V21 = column1.z;
        m.V02 = column2.x;
        m.V12 = column2.y;
        m.V22 = column2.z;
        return m;
    }

    public static Matrix3x3 CreateDiagonal(Vector3 vector) {
        Matrix3x3 m = new Matrix3x3();
        m.V00 = vector.x;
        m.V11 = vector.y;
        m.V22 = vector.z;
        return m;
    }

    public void Multiply(Matrix3x3 matrix) {
        this.V00 = this.V00 * matrix.V00 + this.V01 * matrix.V10 + this.V02 * matrix.V20;
        this.V01 = this.V00 * matrix.V01 + this.V01 * matrix.V11 + this.V02 * matrix.V21;
        this.V02 = this.V00 * matrix.V02 + this.V01 * matrix.V12 + this.V02 * matrix.V22;
        this.V10 = this.V10 * matrix.V00 + this.V11 * matrix.V10 + this.V12 * matrix.V20;
        this.V11 = this.V10 * matrix.V01 + this.V11 * matrix.V11 + this.V12 * matrix.V21;
        this.V12 = this.V10 * matrix.V02 + this.V11 * matrix.V12 + this.V12 * matrix.V22;
        this.V20 = this.V20 * matrix.V00 + this.V21 * matrix.V10 + this.V22 * matrix.V20;
        this.V21 = this.V20 * matrix.V01 + this.V21 * matrix.V11 + this.V22 * matrix.V21;
        this.V22 = this.V20 * matrix.V02 + this.V21 * matrix.V12 + this.V22 * matrix.V22;
    }

    public static Matrix3x3 Multiply(Matrix3x3 matrix1, Matrix3x3 matrix2) {
        Matrix3x3 m = new Matrix3x3();
        m.V00 = matrix1.V00 * matrix2.V00 + matrix1.V01 * matrix2.V10 + matrix1.V02 * matrix2.V20;
        m.V01 = matrix1.V00 * matrix2.V01 + matrix1.V01 * matrix2.V11 + matrix1.V02 * matrix2.V21;
        m.V02 = matrix1.V00 * matrix2.V02 + matrix1.V01 * matrix2.V12 + matrix1.V02 * matrix2.V22;
        m.V10 = matrix1.V10 * matrix2.V00 + matrix1.V11 * matrix2.V10 + matrix1.V12 * matrix2.V20;
        m.V11 = matrix1.V10 * matrix2.V01 + matrix1.V11 * matrix2.V11 + matrix1.V12 * matrix2.V21;
        m.V12 = matrix1.V10 * matrix2.V02 + matrix1.V11 * matrix2.V12 + matrix1.V12 * matrix2.V22;
        m.V20 = matrix1.V20 * matrix2.V00 + matrix1.V21 * matrix2.V10 + matrix1.V22 * matrix2.V20;
        m.V21 = matrix1.V20 * matrix2.V01 + matrix1.V21 * matrix2.V11 + matrix1.V22 * matrix2.V21;
        m.V22 = matrix1.V20 * matrix2.V02 + matrix1.V21 * matrix2.V12 + matrix1.V22 * matrix2.V22;
        return m;
    }

    public void Add(Matrix3x3 matrix) {
        this.V00 += matrix.V00;
        this.V01 += matrix.V01;
        this.V02 += matrix.V02;
        this.V10 += matrix.V10;
        this.V11 += matrix.V11;
        this.V12 += matrix.V12;
        this.V20 += matrix.V20;
        this.V21 += matrix.V21;
        this.V22 += matrix.V22;
    }

    public static Matrix3x3 Add(Matrix3x3 matrix1, Matrix3x3 matrix2) {
        Matrix3x3 m = new Matrix3x3();
        m.V00 = matrix1.V00 + matrix2.V00;
        m.V01 = matrix1.V01 + matrix2.V01;
        m.V02 = matrix1.V02 + matrix2.V02;
        m.V10 = matrix1.V10 + matrix2.V10;
        m.V11 = matrix1.V11 + matrix2.V11;
        m.V12 = matrix1.V12 + matrix2.V12;
        m.V20 = matrix1.V20 + matrix2.V20;
        m.V21 = matrix1.V21 + matrix2.V21;
        m.V22 = matrix1.V22 + matrix2.V22;
        return m;
    }

    public void Subtract(Matrix3x3 matrix) {
        this.V00 -= matrix.V00;
        this.V01 -= matrix.V01;
        this.V02 -= matrix.V02;
        this.V10 -= matrix.V10;
        this.V11 -= matrix.V11;
        this.V12 -= matrix.V12;
        this.V20 -= matrix.V20;
        this.V21 -= matrix.V21;
        this.V22 -= matrix.V22;
    }

    public static Matrix3x3 Subtract(Matrix3x3 matrix1, Matrix3x3 matrix2) {
        Matrix3x3 m = new Matrix3x3();
        m.V00 = matrix1.V00 - matrix2.V00;
        m.V01 = matrix1.V01 - matrix2.V01;
        m.V02 = matrix1.V02 - matrix2.V02;
        m.V10 = matrix1.V10 - matrix2.V10;
        m.V11 = matrix1.V11 - matrix2.V11;
        m.V12 = matrix1.V12 - matrix2.V12;
        m.V20 = matrix1.V20 - matrix2.V20;
        m.V21 = matrix1.V21 - matrix2.V21;
        m.V22 = matrix1.V22 - matrix2.V22;
        return m;
    }
}

