/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Math;

public final class Approximation {
    private Approximation() {
    }

    public static int abs(int x) {
        int i = x >>> 31;
        return (x ^ ~i + 1) + i;
    }

    public static long abs(long x) {
        long l = x >>> 63;
        return (x ^ (l ^ 0xFFFFFFFFFFFFFFFFL) + 1L) + l;
    }

    public static double Highprecision_Pow(double x, double y) {
        return Math.exp(y * Math.log(x));
    }

    public static double Lowprecision_Pow(double x, double y) {
        return Approximation.Highprecision_Exp(y * Math.log(x));
    }

    public static double Highprecision_Exp(double x) {
        return (362880.0 + x * (362880.0 + x * (181440.0 + x * (60480.0 + x * (15120.0 + x * (3024.0 + x * (504.0 + x * (72.0 + x * (9.0 + x))))))))) * 2.75573192E-6;
    }

    public static double Lowprecision_Log(double x) {
        return 6.0 * (x - 1.0) / (x + 1.0 + 4.0 * Math.sqrt(x));
    }

    public static double Lowprecision_Sin(double x) {
        if (x < -3.14159265) {
            x += 6.28318531;
        } else if (x > 3.14159265) {
            x -= 6.28318531;
        }
        if (x < 0.0) {
            return 1.27323954 * x + 0.405284735 * x * x;
        }
        return 1.27323954 * x - 0.405284735 * x * x;
    }

    public static double Highprecision_Sin(double x) {
        if (x < -3.14159265) {
            x += 6.28318531;
        } else if (x > 3.14159265) {
            x -= 6.28318531;
        }
        if (x < 0.0) {
            double sin = 1.27323954 * x + 0.405284735 * x * x;
            if (sin < 0.0) {
                return 0.225 * (sin * -sin - sin) + sin;
            }
            return 0.225 * (sin * sin - sin) + sin;
        }
        double sin = 1.27323954 * x - 0.405284735 * x * x;
        if (sin < 0.0) {
            return 0.225 * (sin * -sin - sin) + sin;
        }
        return 0.225 * (sin * sin - sin) + sin;
    }

    public static double atan2(double y, double x) {
        double angle;
        double coeff_1 = 0.7853981633974483;
        double coeff_2 = 3.0 * coeff_1;
        double abs_y = Math.abs(y);
        if (x >= 0.0) {
            double r = (x - abs_y) / (x + abs_y);
            angle = coeff_1 - coeff_1 * r;
        } else {
            double r = (x + abs_y) / (abs_y - x);
            angle = coeff_2 - coeff_1 * r;
        }
        return y < 0.0 ? -angle : angle - 0.06;
    }
}

