/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.FeatureScaling;

import Catalano.MachineLearning.Dataset.DecisionVariable;
import Catalano.MachineLearning.FeatureScaling.IFeatureScaling;
import Catalano.Math.Matrix;

public class VectorNormalization
implements IFeatureScaling {
    private int l;

    public int getOrder() {
        return this.l;
    }

    public void setOrder(int l) {
        this.l = l;
    }

    public VectorNormalization() {
        this(2);
    }

    public VectorNormalization(int l) {
        this.l = l;
    }

    @Override
    public double[][] Apply(double[][] data) {
        double[][] result = Matrix.Copy(data);
        this.ApplyInPlace(result);
        return result;
    }

    @Override
    public double[][] Apply(DecisionVariable[] variables, double[][] data) {
        double[][] result = Matrix.Copy(data);
        this.ApplyInPlace(variables, result);
        return result;
    }

    @Override
    public void ApplyInPlace(double[][] data) {
        for (int i = 0; i < data.length; ++i) {
            int j;
            double sum = 0.0;
            for (j = 0; j < data[0].length; ++j) {
                sum += Math.pow(Math.abs(data[i][j]), this.l);
            }
            sum = Math.pow(sum, 1.0 / (double)this.l);
            j = 0;
            while (j < data[0].length) {
                double[] dArray = data[i];
                int n = j++;
                dArray[n] = dArray[n] / sum;
            }
        }
    }

    @Override
    public void ApplyInPlace(DecisionVariable[] variables, double[][] data) {
        for (int i = 0; i < data.length; ++i) {
            int j;
            double sum = 0.0;
            for (j = 0; j < data[0].length; ++j) {
                if (variables[j].type != DecisionVariable.Type.Continuous) continue;
                sum += Math.pow(Math.abs(data[i][j]), this.l);
            }
            sum = Math.pow(sum, 1.0 / (double)this.l);
            for (j = 0; j < data[0].length; ++j) {
                if (variables[j].type != DecisionVariable.Type.Continuous) continue;
                double[] dArray = data[i];
                int n = j;
                dArray[n] = dArray[n] / sum;
            }
        }
    }

    @Override
    public double[] Compute(double[] feature) {
        int i;
        double[] result = new double[feature.length];
        double sum = 0.0;
        for (i = 0; i < feature.length; ++i) {
            sum += Math.pow(Math.abs(feature[i]), this.l);
        }
        sum = Math.pow(sum, 1.0 / (double)this.l);
        for (i = 0; i < feature.length; ++i) {
            result[i] = feature[i] / sum;
        }
        return result;
    }

    @Override
    public double[] Compute(DecisionVariable[] variables, double[] feature) {
        int i;
        double[] result = new double[feature.length];
        double sum = 0.0;
        for (i = 0; i < feature.length; ++i) {
            if (variables[i].type != DecisionVariable.Type.Continuous) continue;
            sum += Math.pow(Math.abs(feature[i]), this.l);
        }
        sum = Math.pow(sum, 1.0 / (double)this.l);
        for (i = 0; i < feature.length; ++i) {
            if (variables[i].type != DecisionVariable.Type.Continuous) continue;
            result[i] = feature[i] / sum;
        }
        return result;
    }
}

