/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.FeatureScaling;

import Catalano.MachineLearning.Dataset.DecisionVariable;
import Catalano.MachineLearning.FeatureScaling.IFeatureScaling;

public class LogarithmNormalization
implements IFeatureScaling {
    @Override
    public double[][] Apply(double[][] data) {
        return this.Apply(null, data);
    }

    @Override
    public double[][] Apply(DecisionVariable[] variables, double[][] data) {
        double[][] m = new double[data.length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                m[i][j] = variables[j].type == DecisionVariable.Type.Continuous ? Math.signum(data[i][j]) * Math.log10(Math.abs(data[i][j] + 1.0)) : data[i][j];
            }
        }
        return m;
    }

    @Override
    public void ApplyInPlace(double[][] data) {
        this.ApplyInPlace(null, data);
    }

    @Override
    public void ApplyInPlace(DecisionVariable[] variables, double[][] data) {
        int i;
        if (variables == null) {
            variables = new DecisionVariable[data[0].length + 1];
            for (i = 0; i < variables.length - 1; ++i) {
                variables[i] = new DecisionVariable("F" + i, DecisionVariable.Type.Continuous);
            }
            variables[variables.length - 1] = new DecisionVariable("Class", DecisionVariable.Type.Discrete);
        }
        for (i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                if (variables[j].type != DecisionVariable.Type.Continuous) continue;
                data[i][j] = Math.signum(data[i][j]) * Math.log10(Math.abs(data[i][j] + 1.0));
            }
        }
    }

    @Override
    public double[] Compute(double[] feature) {
        double[] v = new double[feature.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = Math.signum(feature[i]) * Math.log10(Math.abs(feature[i] + 1.0));
        }
        return v;
    }

    @Override
    public double[] Compute(DecisionVariable[] variables, double[] feature) {
        double[] v = new double[feature.length];
        for (int i = 0; i < v.length; ++i) {
            v[i] = variables[i].type == DecisionVariable.Type.Continuous ? Math.signum(feature[i]) * Math.log10(Math.abs(feature[i] + 1.0)) : feature[i];
        }
        return v;
    }
}

