/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Dataset.Imputation;

import Catalano.MachineLearning.Dataset.DecisionVariable;
import Catalano.MachineLearning.Dataset.IDataset;
import Catalano.MachineLearning.Dataset.Imputation.IImputation;
import java.util.ArrayList;
import java.util.Collections;

public class FillMissingValues
implements IImputation {
    private Mode mode;

    public FillMissingValues() {
        this(Mode.Mean);
    }

    public FillMissingValues(Mode mode) {
        this.mode = mode;
    }

    @Override
    public void ApplyInPlace(IDataset dataset) {
        DecisionVariable[] dv = dataset.getDecisionVariables();
        double[][] input = (double[][])dataset.getInput();
        for (int j = 0; j < dv.length; ++j) {
            if (dv[j].type != DecisionVariable.Type.Continuous) continue;
            double value = 0.0;
            if (this.mode == Mode.Mean) {
                double max = 0.0;
                for (int i = 0; i < input.length; ++i) {
                    if (Double.isNaN(input[i][j])) continue;
                    value += input[i][j];
                    max += 1.0;
                }
                value /= max;
            } else if (this.mode == Mode.Median) {
                ArrayList<Double> elem = new ArrayList<Double>();
                for (int i = 0; i < input.length; ++i) {
                    if (Double.isNaN(input[i][j])) continue;
                    elem.add(input[i][j]);
                }
                Collections.sort(elem);
                value = (Double)elem.get(elem.size() / 2);
            }
            for (int i = 0; i < input.length; ++i) {
                if (input[i][j] != Double.NaN) continue;
                input[i][j] = value;
            }
        }
    }

    public static enum Mode {
        Mean,
        Median;

    }
}

