/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning;

import Catalano.MachineLearning.Classification.IClassifier;
import java.util.HashMap;

public class ConfusionMatrix {
    private int[][] confusion;
    private double[] tp;
    private double[] fp;
    private double[] precision;
    private double[] fMeasure;

    public static int[][] Create(IClassifier classifier, double[][] validation, int[] labels) {
        HashMap<Integer, Integer> unique = new HashMap<Integer, Integer>();
        int idx = 0;
        for (int i = 0; i < labels.length; ++i) {
            if (unique.containsKey(labels[i])) continue;
            unique.put(labels[i], idx++);
        }
        int[][] confusion = new int[unique.size()][unique.size()];
        for (int i = 0; i < validation.length; ++i) {
            int obj = classifier.Predict(validation[i]);
            int[] nArray = confusion[(Integer)unique.get(labels[i])];
            int n = (Integer)unique.get(obj);
            nArray[n] = nArray[n] + 1;
        }
        return confusion;
    }

    public double[] getTruePositiveRate() {
        return this.tp;
    }

    public double[] getFalsePositiveRate() {
        return this.fp;
    }

    public double[] getPrecision() {
        return this.precision;
    }

    public double[] getFMeasure() {
        return this.fMeasure;
    }

    public ConfusionMatrix(int[][] confusionMatrix) {
        this.confusion = confusionMatrix;
        this.Compute(confusionMatrix);
    }

    private void Compute(int[][] confusionMatrix) {
        int j;
        int sum;
        int i;
        int[] classes = new int[confusionMatrix[0].length];
        this.tp = new double[confusionMatrix[0].length];
        this.fp = new double[confusionMatrix[0].length];
        this.precision = new double[confusionMatrix[0].length];
        this.fMeasure = new double[confusionMatrix[0].length];
        for (i = 0; i < confusionMatrix.length; ++i) {
            sum = 0;
            for (int j2 = 0; j2 < confusionMatrix[0].length; ++j2) {
                sum += confusionMatrix[i][j2];
            }
            classes[i] = sum;
        }
        for (i = 0; i < this.tp.length; ++i) {
            this.tp[i] = (double)confusionMatrix[i][i] / (double)classes[i];
        }
        for (j = 0; j < confusionMatrix[0].length; ++j) {
            sum = 0;
            int sumC = 0;
            int sumP = 0;
            for (int i2 = 0; i2 < confusionMatrix.length; ++i2) {
                if (i2 != j) {
                    sum += confusionMatrix[i2][j];
                    sumC += classes[i2];
                }
                sumP += confusionMatrix[i2][j];
            }
            this.fp[j] = (double)sum / (double)sumC;
            sumP = sumP == 0 ? 1 : sumP;
            this.precision[j] = (double)confusionMatrix[j][j] / (double)sumP;
        }
        for (j = 0; j < confusionMatrix[0].length; ++j) {
            int sumFP = 0;
            int sumFN = 0;
            for (int i3 = 0; i3 < confusionMatrix.length; ++i3) {
                if (i3 == j) continue;
                sumFP += confusionMatrix[i3][j];
            }
            for (int k = 0; k < confusionMatrix[0].length; ++k) {
                if (k == j) continue;
                sumFN += confusionMatrix[j][k];
            }
            this.fMeasure[j] = (double)(2 * confusionMatrix[j][j]) / (double)(2 * confusionMatrix[j][j] + sumFP + sumFN);
        }
    }
}

