/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Classification;

import Catalano.MachineLearning.Classification.SVM;
import Catalano.Math.SparseArray;
import Catalano.Statistics.Kernels.IMercerKernel;
import java.io.Serializable;

public class SparseSupportVectorMachine
implements Serializable {
    private IMercerKernel kernel;
    private double c;
    private double cn;
    private SVM<SparseArray> svm;

    public SparseSupportVectorMachine(IMercerKernel kernel, double c) {
        this(kernel, c, c);
    }

    public SparseSupportVectorMachine(IMercerKernel kernel, double c, double cn) {
        this.kernel = kernel;
        this.c = c;
        this.cn = cn;
        this.Initialize(kernel, c, cn);
    }

    private void Initialize(IMercerKernel kernel, double c, double cn) {
        this.svm = new SVM(kernel, c, cn);
    }

    public void Learn(SparseArray[] input, int[] output) {
        this.Initialize(this.kernel, this.c, this.cn);
        this.svm.Learn((SparseArray[])input, output);
    }

    public void Learn(SparseArray input, int output) {
        this.svm.Learn(input, output);
    }

    public int Predict(SparseArray feature) {
        return this.svm.Predict(feature);
    }

    public void Finish() {
        this.svm.Finish();
    }
}

