/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning.Classification;

import Catalano.Core.ArraysUtil;
import Catalano.MachineLearning.Classification.IClassifier;
import Catalano.MachineLearning.Dataset.DatasetClassification;
import Catalano.Math.Distances.IDivergence;
import Catalano.Math.Distances.SquaredEuclideanDistance;
import Catalano.Math.Matrix;
import Catalano.Math.Tools;
import Catalano.Statistics.Kernels.IMercerKernel;
import java.io.Serializable;

public class RadiusNearestNeighbors
implements IClassifier,
Serializable {
    private double radius;
    private double[][] input;
    private int[] output;
    private IDivergence divergence = new SquaredEuclideanDistance();
    private IMercerKernel kernel;
    private boolean useKernel = false;

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public IMercerKernel getKernel() {
        return this.kernel;
    }

    public void setMercerKernel(IMercerKernel kernel) {
        this.kernel = kernel;
        this.useKernel = true;
    }

    public IDivergence getDistance() {
        return this.divergence;
    }

    public void setDistance(IDivergence divergence) {
        this.divergence = divergence;
        this.useKernel = false;
    }

    public RadiusNearestNeighbors() {
        this(0.05);
    }

    public RadiusNearestNeighbors(double radius) {
        this(radius, new SquaredEuclideanDistance());
    }

    public RadiusNearestNeighbors(double radius, IDivergence divergence) {
        this.radius = radius;
        this.divergence = divergence;
    }

    public RadiusNearestNeighbors(double radius, IMercerKernel kernel) {
        this.radius = radius;
        this.kernel = kernel;
        this.useKernel = true;
    }

    @Override
    public void Learn(DatasetClassification dataset) {
        this.Learn(dataset.getInput(), dataset.getOutput());
    }

    @Override
    public void Learn(double[][] input, int[] output) {
        this.input = input;
        this.output = output;
    }

    @Override
    public int Predict(double[] feature) {
        int i;
        int sizeF = this.input.length;
        double[] dist = new double[sizeF];
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        if (this.useKernel) {
            for (i = 0; i < sizeF; ++i) {
                dist[i] = this.kernel.Function(feature, this.input[i]);
                max = Math.max(max, dist[i]);
                min = Math.min(min, dist[i]);
            }
        } else {
            for (i = 0; i < sizeF; ++i) {
                dist[i] = this.divergence.Compute(feature, this.input[i]);
                max = Math.max(max, dist[i]);
                min = Math.min(min, dist[i]);
            }
        }
        for (i = 0; i < dist.length; ++i) {
            dist[i] = Tools.Scale(min, max, 0.0, 1.0, dist[i]);
        }
        int[] indexes = ArraysUtil.Argsort(dist, true);
        int k = this.Min(dist, indexes);
        int classes = Matrix.Max(this.output) + 1;
        int[] votes = new int[classes];
        for (int i2 = 0; i2 < k; ++i2) {
            int n = this.output[indexes[i2]];
            votes[n] = votes[n] + 1;
        }
        return Matrix.MaxIndex(votes);
    }

    private int Min(double[] dist, int[] indexes) {
        int e = 0;
        for (int i = 0; i < indexes.length; ++i) {
            if (dist[indexes[i]] > this.radius) {
                return e;
            }
            ++e;
        }
        return e;
    }

    @Override
    public IClassifier clone() {
        try {
            return (IClassifier)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException("Clone not supported: " + ex.getMessage());
        }
    }
}

