/*
 * Decompiled with CFR 0.152.
 */
package Catalano.MachineLearning;

import Catalano.MachineLearning.Classification.IClassifier;
import Catalano.MachineLearning.Dataset.DatasetClassification;
import Catalano.MachineLearning.Performance.IValidation;
import java.util.List;

public class BenchmarkClassifier {
    private final double[][] input;
    private final int[] output;
    private IClassifier bestClassifier;
    private double[] rank;

    public IClassifier getBestClassifier() {
        return this.bestClassifier;
    }

    public double[] getRank() {
        return this.rank;
    }

    public BenchmarkClassifier(DatasetClassification dataset) {
        this(dataset.getInput(), dataset.getOutput());
    }

    public BenchmarkClassifier(double[][] input, int[] output) {
        this.input = input;
        this.output = output;
    }

    public void Compute(List<IClassifier> classifiers, IValidation validation) {
        if (classifiers.size() < 1) {
            throw new IllegalArgumentException("Need at least one more classifiers.");
        }
        this.rank = new double[classifiers.size()];
        double bestC = 0.0;
        for (int i = 0; i < classifiers.size(); ++i) {
            IClassifier c = classifiers.get(i);
            this.rank[i] = validation.Run(c, this.input, this.output);
            if (!(this.rank[i] > bestC)) continue;
            bestC = this.rank[i];
            this.bestClassifier = c;
        }
    }
}

