/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.ArraysUtil;
import Catalano.Math.Decompositions.SingularValueDecomposition;
import Catalano.Math.Matrix;

public class Kernel {
    public static double[][] Decompose(double[][] kernel) {
        int i;
        SingularValueDecomposition svd = new SingularValueDecomposition(kernel);
        double[][] u = svd.getU();
        double[][] v = svd.getV();
        double s = Math.sqrt(svd.getS()[0][0]);
        double[] row = new double[svd.getV().length];
        double[] col = new double[svd.getU().length];
        double[][] vectors = new double[2][];
        for (i = 0; i < row.length; ++i) {
            row[i] = v[i][0] * s;
        }
        for (i = 0; i < col.length; ++i) {
            col[i] = u[i][0] * s;
        }
        vectors[0] = row;
        vectors[1] = col;
        return vectors;
    }

    public static double[][] Normalize(double[][] kernel) {
        double sum = Matrix.Sum(kernel);
        if (sum != 0.0) {
            double[][] result = Matrix.Copy(kernel);
            Matrix.Divide(result, sum);
            return result;
        }
        return kernel;
    }

    public static boolean isNormalized(double[][] kernel) {
        double sum = Matrix.Sum(kernel);
        return sum >= 0.99 && sum <= 1.0;
    }

    public static boolean isSeparable(int[][] kernel) {
        double[][] m = ArraysUtil.toDouble(kernel);
        SingularValueDecomposition svd = new SingularValueDecomposition(m);
        return svd.rank() == 1;
    }

    public static double[][] toDouble(int[][] kernel) {
        double sum = 0.0;
        for (int i = 0; i < kernel.length; ++i) {
            for (int j = 0; j < kernel[0].length; ++j) {
                sum += (double)Math.abs(kernel[i][j]);
            }
        }
        double[][] k = new double[kernel.length][kernel[0].length];
        for (int i = 0; i < kernel.length; ++i) {
            for (int j = 0; j < kernel[0].length; ++j) {
                k[i][j] = kernel[i][j] < 0 ? -((double)kernel[i][j] / sum) : (double)kernel[i][j] / sum;
            }
        }
        return k;
    }

    public static int[][] toInt(double[][] kernel) {
        double min = Matrix.Min(kernel);
        if (min == 0.0) {
            throw new IllegalArgumentException("The kernel can't be normalized.");
        }
        int[][] k = new int[kernel.length][kernel[0].length];
        for (int i = 0; i < kernel.length; ++i) {
            for (int j = 0; j < kernel[0].length; ++j) {
                k[i][j] = (int)(kernel[i][j] / min);
            }
        }
        return k;
    }

    public static int[] toInt(double[] kernel) {
        double min = Matrix.Min(kernel);
        if (min == 0.0) {
            throw new IllegalArgumentException("The kernel can't be normalized.");
        }
        int[] k = new int[kernel.length];
        for (int i = 0; i < kernel.length; ++i) {
            k[i] = (int)(kernel[i] / min);
        }
        return k;
    }
}

