/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Tools.ImageHistogram;

public class ImageStatistics {
    private ImageHistogram gray = null;
    private ImageHistogram red = null;
    private ImageHistogram green = null;
    private ImageHistogram blue = null;
    private int pixels = 0;

    public ImageHistogram getHistogramGray() {
        if (this.gray == null) {
            throw new IllegalArgumentException("Histogram gray is null");
        }
        return this.gray;
    }

    public ImageHistogram getHistogramRed() {
        if (this.red == null) {
            throw new IllegalArgumentException("Histogram red is null");
        }
        return this.red;
    }

    public ImageHistogram getHistogramGreen() {
        if (this.green == null) {
            throw new IllegalArgumentException("Histogram green is null");
        }
        return this.green;
    }

    public ImageHistogram getHistogramBlue() {
        if (this.blue == null) {
            throw new IllegalArgumentException("Histogram blue is null");
        }
        return this.blue;
    }

    public ImageStatistics(FastBitmap fastBitmap) {
        this(fastBitmap, 256);
    }

    public ImageStatistics(FastBitmap fastBitmap, int bins) {
        int size = fastBitmap.getWidth() * fastBitmap.getHeight();
        if (fastBitmap.isGrayscale()) {
            int[] g = new int[bins];
            for (int i = 0; i < size; ++i) {
                int G = fastBitmap.getGray(i);
                int n = G * bins / 256;
                g[n] = g[n] + 1;
                ++this.pixels;
            }
            this.gray = new ImageHistogram(g);
        } else if (fastBitmap.isRGB()) {
            int[] r = new int[bins];
            int[] g = new int[bins];
            int[] b = new int[bins];
            for (int i = 0; i < size; ++i) {
                int R = fastBitmap.getRed(i);
                int G = fastBitmap.getGreen(i);
                int B = fastBitmap.getBlue(i);
                int n = R * bins / 256;
                r[n] = r[n] + 1;
                int n2 = G * bins / 256;
                g[n2] = g[n2] + 1;
                int n3 = B * bins / 256;
                b[n3] = b[n3] + 1;
                ++this.pixels;
            }
            this.red = new ImageHistogram(r);
            this.green = new ImageHistogram(g);
            this.blue = new ImageHistogram(b);
        }
    }

    public int PixelsCount() {
        return this.pixels;
    }

    public static float Mean(FastBitmap fastBitmap) {
        return ImageStatistics.Mean(fastBitmap, 0, 0, fastBitmap.getWidth(), fastBitmap.getHeight());
    }

    public static float Mean(FastBitmap fastBitmap, int startX, int startY, int width, int height) {
        float mean = 0.0f;
        if (fastBitmap.isGrayscale()) {
            for (int i = startX; i < height; ++i) {
                for (int j = startY; j < width; ++j) {
                    mean += (float)fastBitmap.getGray(i, j);
                }
            }
            return mean / (float)(width * height);
        }
        throw new IllegalArgumentException("ImageStatistics: Only compute mean in grayscale images.");
    }

    public static float Variance(FastBitmap fastBitmap) {
        float mean = ImageStatistics.Mean(fastBitmap);
        return ImageStatistics.Variance(fastBitmap, mean);
    }

    public static float Variance(FastBitmap fastBitmap, float mean) {
        return ImageStatistics.Variance(fastBitmap, mean, 0, 0, fastBitmap.getWidth(), fastBitmap.getHeight());
    }

    public static float Variance(FastBitmap fastBitmap, float mean, int startX, int startY, int width, int height) {
        float sum = 0.0f;
        if (fastBitmap.isGrayscale()) {
            for (int i = startX; i < height; ++i) {
                for (int j = startY; j < width; ++j) {
                    sum = (float)((double)sum + Math.pow((float)fastBitmap.getGray(i, j) - mean, 2.0));
                }
            }
            return sum / (float)(width * height - 1);
        }
        throw new IllegalArgumentException("ImageStatistics: Only compute variance in grayscale images.");
    }

    public static int Maximum(FastBitmap fastBitmap) {
        return ImageStatistics.Maximum(fastBitmap, 0, 0, fastBitmap.getWidth(), fastBitmap.getHeight());
    }

    public static int Maximum(FastBitmap fastBitmap, int startX, int startY, int width, int height) {
        int max = 0;
        for (int i = startX; i < height; ++i) {
            for (int j = startY; j < width; ++j) {
                int gray = fastBitmap.getGray(i, j);
                if (gray <= max) continue;
                max = gray;
            }
        }
        return max;
    }

    public static int Minimum(FastBitmap fastBitmap) {
        return ImageStatistics.Minimum(fastBitmap, 0, 0, fastBitmap.getWidth(), fastBitmap.getHeight());
    }

    public static int Minimum(FastBitmap fastBitmap, int startX, int startY, int width, int height) {
        int min = 255;
        for (int i = startX; i < height; ++i) {
            for (int j = startY; j < width; ++j) {
                int gray = fastBitmap.getGray(i, j);
                if (gray >= min) continue;
                min = gray;
            }
        }
        return min;
    }
}

