/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class ImagePadding
implements IApplyInPlace {
    private int w = 1;
    private int h = 1;

    public int getWidth() {
        return this.w;
    }

    public void setWidth(int width) {
        this.w = width;
    }

    public int getHeight() {
        return this.h;
    }

    public void setHeight(int height) {
        this.h = height;
    }

    public void setSize(int size) {
        this.w = this.h = size;
    }

    public ImagePadding() {
    }

    public ImagePadding(int size) {
        this.w = size;
        this.h = size;
    }

    public ImagePadding(int width, int height) {
        this.w = width;
        this.h = height;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int j;
        int i;
        FastBitmap fb;
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        int newWidth = width + this.w;
        int newHeight = height + this.h;
        int startI = (newHeight - height) / 2;
        int startJ = (newWidth - width) / 2;
        int moveI = 0;
        int moveJ = 0;
        if (this.h % 2 != 0) {
            moveI = 1;
        }
        if (this.w % 2 != 0) {
            moveJ = 1;
        }
        if ((fb = new FastBitmap(newWidth, newHeight, fastBitmap.getColorSpace())).isGrayscale()) {
            for (i = startI; i < newHeight - startI - moveI; ++i) {
                for (j = startJ; j < newWidth - startJ - moveJ; ++j) {
                    fb.setGray(i, j, fastBitmap.getGray(i - startI, j - startJ));
                }
            }
        }
        if (fb.isRGB()) {
            for (i = startI; i < newHeight - startI - moveI; ++i) {
                for (j = startJ; j < newWidth - startJ - moveJ; ++j) {
                    fb.setRGB(i, j, fastBitmap.getRed(i - startI, j - startJ), fastBitmap.getGreen(i - startI, j - startJ), fastBitmap.getBlue(i - startI, j - startJ));
                }
            }
        }
        fastBitmap.setImage(fb);
    }
}

