/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Tools.Blob;
import Catalano.Imaging.Tools.BlobDetection;
import Catalano.Imaging.Tools.BlobExtractor;
import java.util.List;

public class ExtractBiggestBlob {
    private boolean keepOriginalImage;

    public ExtractBiggestBlob() {
        this(false);
    }

    public ExtractBiggestBlob(boolean keepOriginalImage) {
        this.keepOriginalImage = keepOriginalImage;
    }

    public FastBitmap Extract(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Extract Biggest Blob only works in grayscale images.");
        }
        BlobDetection bd = new BlobDetection();
        List<Blob> blobs = bd.ProcessImage(fastBitmap);
        Blob blob = blobs.get(bd.getIdBiggestBlob());
        if (!this.keepOriginalImage) {
            BlobExtractor e = new BlobExtractor();
            return e.Extract(fastBitmap, blob);
        }
        FastBitmap fb = new FastBitmap(fastBitmap.getWidth(), fastBitmap.getHeight(), FastBitmap.ColorSpace.Grayscale);
        List<IntPoint> points = blob.getPoints();
        for (IntPoint p : points) {
            fb.setGray(p, fastBitmap.getGray(p));
        }
        return fb;
    }
}

