/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Imaging.FastBitmap;

public class ColorMoments {
    private double[] weight = new double[]{1.0, 1.0, 1.0};

    public double[] getWeight() {
        return this.weight;
    }

    public void setWeight(double[] weight) {
        this.weight = weight;
    }

    public ColorMoments() {
    }

    public ColorMoments(double weight1, double weight2, double weight3) {
        this.weight = new double[]{weight1, weight2, weight3};
    }

    public double Compute(FastBitmap fastBitmap1, FastBitmap fastBitmap2) {
        double[][] momentA = this.ComputeMatrixMoment(fastBitmap1);
        double[][] momentB = this.ComputeMatrixMoment(fastBitmap2);
        return this.Compute(momentA, momentB);
    }

    public double Compute(double[][] momentA, double[][] momentB) {
        double moment = 0.0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                moment += this.weight[j] * Math.abs(momentA[i][j] - momentB[i][j]);
            }
        }
        return moment;
    }

    public double[][] ComputeMatrixMoment(FastBitmap fastBitmap) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        double size = width * height;
        int sumR = 0;
        int sumG = 0;
        int sumB = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                sumR += fastBitmap.getRed(i, j);
                sumG += fastBitmap.getGreen(i, j);
                sumB += fastBitmap.getBlue(i, j);
            }
        }
        double meanR = (double)sumR / size;
        double meanG = (double)sumG / size;
        double meanB = (double)sumB / size;
        double stdR = 0.0;
        double stdG = 0.0;
        double stdB = 0.0;
        double skwR = 0.0;
        double skwG = 0.0;
        double skwB = 0.0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                stdR += Math.pow((double)fastBitmap.getRed(i, j) - meanR, 2.0);
                stdG += Math.pow((double)fastBitmap.getGreen(i, j) - meanG, 2.0);
                stdB += Math.pow((double)fastBitmap.getBlue(i, j) - meanB, 2.0);
                skwR += Math.pow((double)fastBitmap.getRed(i, j) - meanR, 3.0);
                skwG += Math.pow((double)fastBitmap.getGreen(i, j) - meanG, 3.0);
                skwB += Math.pow((double)fastBitmap.getBlue(i, j) - meanB, 3.0);
            }
        }
        stdR = Math.sqrt(stdR / size);
        stdG = Math.sqrt(stdG / size);
        stdB = Math.sqrt(stdB / size);
        skwR = Math.pow(skwR, 0.33);
        skwG = Math.pow(skwG, 0.33);
        skwB = Math.pow(skwB, 0.33);
        double[][] moment = new double[3][3];
        moment[0][0] = meanR;
        moment[0][1] = stdR;
        moment[0][2] = skwR;
        moment[1][0] = meanG;
        moment[1][1] = stdG;
        moment[1][2] = skwG;
        moment[2][0] = meanB;
        moment[2][1] = stdB;
        moment[2][2] = skwB;
        return moment;
    }
}

