/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Tools;

import Catalano.Core.IntPoint;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Shapes.IntRectangle;
import Catalano.Imaging.Tools.Blob;
import java.util.List;

public class BlobExtractor {
    private boolean keepOriginalImage;

    public boolean isKeepOriginalImage() {
        return this.keepOriginalImage;
    }

    public void setKeepOriginalImage(boolean keepOriginalImage) {
        this.keepOriginalImage = keepOriginalImage;
    }

    public BlobExtractor() {
        this(false);
    }

    public BlobExtractor(boolean keepOriginalImage) {
        this.keepOriginalImage = keepOriginalImage;
    }

    public FastBitmap Extract(FastBitmap fastBitmap, Blob blob) {
        List<IntPoint> points = blob.getPoints();
        IntRectangle rect = blob.getBoundingBox();
        if (!this.keepOriginalImage) {
            int height = blob.getHeight() + 1;
            int width = blob.getWidth() + 1;
            FastBitmap image = new FastBitmap(width, height, fastBitmap.getColorSpace());
            if (image.isGrayscale()) {
                for (IntPoint p : points) {
                    image.setGray(p.x - rect.x, p.y - rect.y, fastBitmap.getGray(p));
                }
            } else {
                for (IntPoint p : points) {
                    image.setRGB(p.x - rect.x, p.y - rect.y, fastBitmap.getRGB(p));
                }
            }
            return image;
        }
        FastBitmap image = new FastBitmap(fastBitmap.getWidth(), fastBitmap.getHeight(), fastBitmap.getColorSpace());
        if (image.isGrayscale()) {
            for (IntPoint p : points) {
                image.setGray(p, fastBitmap.getGray(p));
            }
        } else {
            for (IntPoint p : points) {
                image.setRGB(p, fastBitmap.getRGB(p));
            }
        }
        return image;
    }
}

