/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Texture;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Tools.ImageStatistics;

public class GrayLevelRunLengthMatrix {
    private Degree degree;
    private int numPrimitives;
    private boolean autoGray = true;

    public boolean isAutoGray() {
        return this.autoGray;
    }

    public void setAutoGray(boolean autoGray) {
        this.autoGray = autoGray;
    }

    public Degree getDegree() {
        return this.degree;
    }

    public void setDegree(Degree degree) {
        this.degree = degree;
    }

    public int getNumberPrimitives() {
        return this.numPrimitives;
    }

    public void setNumberPrimitives(int numberPrimitives) {
        this.numPrimitives = numberPrimitives;
    }

    public GrayLevelRunLengthMatrix(Degree degree) {
        this.degree = degree;
    }

    public GrayLevelRunLengthMatrix(Degree degree, boolean autoGray) {
        this.degree = degree;
        this.autoGray = autoGray;
    }

    public double[][] Compute(FastBitmap fastBitmap) {
        int maxGray = 255;
        if (this.autoGray) {
            maxGray = ImageStatistics.Maximum(fastBitmap);
        }
        int height = fastBitmap.getHeight();
        int width = fastBitmap.getWidth();
        double[][] runMatrix = new double[maxGray + 1][width + 1];
        switch (this.degree) {
            case Degree_0: {
                for (int i = 0; i < height; ++i) {
                    int runs = 1;
                    for (int j = 1; j < width; ++j) {
                        int g2;
                        int g1 = fastBitmap.getGray(i, j - 1);
                        if (g1 == (g2 = fastBitmap.getGray(i, j))) {
                            ++runs;
                        } else {
                            double[] dArray = runMatrix[g1];
                            int n = runs;
                            dArray[n] = dArray[n] + 1.0;
                            ++this.numPrimitives;
                            runs = 1;
                        }
                        if (g1 == g2 && j == width - 1) {
                            double[] dArray = runMatrix[g1];
                            int n = runs;
                            dArray[n] = dArray[n] + 1.0;
                        }
                        if (g1 == g2 || j != width - 1) continue;
                        double[] dArray = runMatrix[g2];
                        dArray[1] = dArray[1] + 1.0;
                    }
                }
                break;
            }
            case Degree_45: {
                int g2;
                int g1;
                int steps;
                int runs;
                double[] dArray = runMatrix[0];
                dArray[1] = dArray[1] + 1.0;
                double[] dArray2 = runMatrix[height - 1];
                int n = width - 1;
                dArray2[n] = dArray2[n] + 1.0;
                for (int i = 1; i < height; ++i) {
                    runs = 1;
                    steps = i;
                    for (int j = 0; j < steps; ++j) {
                        g1 = fastBitmap.getGray(i - j, j);
                        if (g1 == (g2 = fastBitmap.getGray(i - j - 1, j + 1))) {
                            ++runs;
                        } else {
                            double[] dArray3 = runMatrix[g1];
                            int n2 = runs;
                            dArray3[n2] = dArray3[n2] + 1.0;
                            ++this.numPrimitives;
                            runs = 1;
                        }
                        if (g1 == g2 && j == steps - 1) {
                            double[] dArray4 = runMatrix[g1];
                            int n3 = runs;
                            dArray4[n3] = dArray4[n3] + 1.0;
                        }
                        if (g1 == g2 || j != steps - 1) continue;
                        double[] dArray5 = runMatrix[g2];
                        dArray5[1] = dArray5[1] + 1.0;
                    }
                }
                for (int j = 1; j < width - 1; ++j) {
                    runs = 1;
                    steps = height - j;
                    for (int i = 1; i < steps; ++i) {
                        g1 = fastBitmap.getGray(height - i, j + i - 1);
                        if (g1 == (g2 = fastBitmap.getGray(height - i - 1, j + i))) {
                            ++runs;
                        } else {
                            double[] dArray6 = runMatrix[g1];
                            int n4 = runs;
                            dArray6[n4] = dArray6[n4] + 1.0;
                            ++this.numPrimitives;
                            runs = 1;
                        }
                        if (g1 == g2 && i == steps - 1) {
                            double[] dArray7 = runMatrix[g1];
                            int n5 = runs;
                            dArray7[n5] = dArray7[n5] + 1.0;
                        }
                        if (g1 == g2 || i != steps - 1) continue;
                        double[] dArray8 = runMatrix[g2];
                        dArray8[1] = dArray8[1] + 1.0;
                    }
                }
                break;
            }
            case Degree_90: {
                for (int j = 0; j < width; ++j) {
                    int runs = 1;
                    for (int i = 0; i < height - 1; ++i) {
                        int g2;
                        int g1 = fastBitmap.getGray(height - i - 1, j);
                        if (g1 == (g2 = fastBitmap.getGray(height - i - 2, j))) {
                            ++runs;
                        } else {
                            double[] dArray = runMatrix[g1];
                            int n = runs;
                            dArray[n] = dArray[n] + 1.0;
                            ++this.numPrimitives;
                            runs = 1;
                        }
                        if (g1 == g2 && i == height - 2) {
                            double[] dArray = runMatrix[g1];
                            int n = runs;
                            dArray[n] = dArray[n] + 1.0;
                        }
                        if (g1 == g2 || i != height - 2) continue;
                        double[] dArray = runMatrix[g2];
                        dArray[1] = dArray[1] + 1.0;
                    }
                }
                break;
            }
            case Degree_135: {
                int g2;
                int g1;
                int w;
                int steps;
                int runs;
                double[] dArray = runMatrix[0];
                int n = width - 1;
                dArray[n] = dArray[n] + 1.0;
                double[] dArray9 = runMatrix[height - 1];
                dArray9[0] = dArray9[0] + 1.0;
                for (int i = 1; i < width; ++i) {
                    runs = 1;
                    steps = i;
                    w = width - 1;
                    for (int j = 0; j < steps; ++j) {
                        g1 = fastBitmap.getGray(i - j, w);
                        if (g1 == (g2 = fastBitmap.getGray(i - j - 1, --w))) {
                            ++runs;
                        } else {
                            double[] dArray10 = runMatrix[g1];
                            int n6 = runs;
                            dArray10[n6] = dArray10[n6] + 1.0;
                            ++this.numPrimitives;
                            runs = 1;
                        }
                        if (g1 == g2 && j == steps - 1) {
                            double[] dArray11 = runMatrix[g1];
                            int n7 = runs;
                            dArray11[n7] = dArray11[n7] + 1.0;
                        }
                        if (g1 == g2 || j != steps - 1) continue;
                        double[] dArray12 = runMatrix[g2];
                        dArray12[1] = dArray12[1] + 1.0;
                    }
                }
                for (int j = 1; j < width - 1; ++j) {
                    runs = 1;
                    steps = height - j;
                    w = width - 1 - j;
                    for (int i = 1; i < steps; ++i) {
                        g1 = fastBitmap.getGray(height - i, w);
                        if (g1 == (g2 = fastBitmap.getGray(height - i - 1, --w))) {
                            ++runs;
                        } else {
                            double[] dArray13 = runMatrix[g1];
                            int n8 = runs;
                            dArray13[n8] = dArray13[n8] + 1.0;
                            ++this.numPrimitives;
                            runs = 1;
                        }
                        if (g1 == g2 && i == steps - 1) {
                            double[] dArray14 = runMatrix[g1];
                            int n9 = runs;
                            dArray14[n9] = dArray14[n9] + 1.0;
                        }
                        if (g1 == g2 || i != steps - 1) continue;
                        double[] dArray15 = runMatrix[g2];
                        dArray15[1] = dArray15[1] + 1.0;
                    }
                }
                break;
            }
        }
        return runMatrix;
    }

    public static enum Degree {
        Degree_0,
        Degree_45,
        Degree_90,
        Degree_135;

    }
}

