/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Texture;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Tools.ImageStatistics;
import Catalano.Statistics.Histogram;

public class GrayLevelDifferenceMethod {
    private Degree degree;
    private boolean autoGray = true;

    public boolean isAutoGray() {
        return this.autoGray;
    }

    public void setAutoGray(boolean autoGray) {
        this.autoGray = autoGray;
    }

    public Degree getDegree() {
        return this.degree;
    }

    public void setDegree(Degree degree) {
        this.degree = degree;
    }

    public GrayLevelDifferenceMethod(Degree degree) {
        this.degree = degree;
    }

    public GrayLevelDifferenceMethod(Degree degree, boolean autoGray) {
        this.degree = degree;
        this.autoGray = autoGray;
    }

    public Histogram Compute(FastBitmap fastBitmap) {
        int maxGray = 255;
        if (this.autoGray) {
            maxGray = ImageStatistics.Maximum(fastBitmap);
        }
        int height = fastBitmap.getHeight();
        int width = fastBitmap.getWidth();
        int[] hist = new int[maxGray + 1];
        switch (this.degree) {
            case Degree_0: {
                for (int i = 0; i < height; ++i) {
                    for (int j = 1; j < width; ++j) {
                        int g1 = fastBitmap.getGray(i, j - 1);
                        int g2 = fastBitmap.getGray(i, j);
                        int n = Math.abs(g1 - g2);
                        hist[n] = hist[n] + 1;
                    }
                }
                break;
            }
            case Degree_45: {
                for (int x = 1; x < height; ++x) {
                    for (int y = 0; y < width - 1; ++y) {
                        int g1 = fastBitmap.getGray(x, y);
                        int g2 = fastBitmap.getGray(x - 1, y + 1);
                        int n = Math.abs(g1 - g2);
                        hist[n] = hist[n] + 1;
                    }
                }
                break;
            }
            case Degree_90: {
                for (int i = 1; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        int g1 = fastBitmap.getGray(i - 1, j);
                        int g2 = fastBitmap.getGray(i, j);
                        int n = Math.abs(g1 - g2);
                        hist[n] = hist[n] + 1;
                    }
                }
                break;
            }
            case Degree_135: {
                for (int x = 1; x < height; ++x) {
                    int steps = width - 1;
                    for (int y = 0; y < width - 1; ++y) {
                        int g1 = fastBitmap.getGray(x, steps - y);
                        int g2 = fastBitmap.getGray(x - 1, steps - 1 - y);
                        int n = Math.abs(g1 - g2);
                        hist[n] = hist[n] + 1;
                    }
                }
                break;
            }
        }
        return new Histogram(hist);
    }

    public static enum Degree {
        Degree_0,
        Degree_45,
        Degree_90,
        Degree_135;

    }
}

