/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Shapes;

import Catalano.Core.DoublePoint;
import Catalano.Core.FloatPoint;
import Catalano.Core.IntPoint;

public class IntRectangle {
    public int x;
    public int y;
    public int width;
    public int height;

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public IntRectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public IntRectangle(float x, float y, int width, int height) {
        this.x = (int)x;
        this.y = (int)y;
        this.width = width;
        this.height = height;
    }

    public IntRectangle(double x, double y, int width, int height) {
        this.x = (int)x;
        this.y = (int)y;
        this.width = width;
        this.height = height;
    }

    public IntRectangle(IntPoint p, int width, int height) {
        this.x = p.x;
        this.y = p.y;
        this.width = width;
        this.height = height;
    }

    public IntRectangle(FloatPoint p, int width, int height) {
        this.x = (int)p.x;
        this.y = (int)p.y;
        this.width = width;
        this.height = height;
    }

    public IntRectangle(DoublePoint p, int width, int height) {
        this.x = (int)p.x;
        this.y = (int)p.y;
        this.width = width;
        this.height = height;
    }

    public IntRectangle(IntRectangle rectangle) {
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
    }

    public boolean isInside(IntPoint p) {
        return this.isInside(p.x, p.y);
    }

    public boolean isInside(int x, int y) {
        return x >= this.x && x <= this.height && y >= this.y && y <= this.width;
    }

    public boolean isOverlaped(IntRectangle rect) {
        return this.isOverlaped(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean isOverlaped(int x, int y, int width, int height) {
        return this.x < x + height && this.x + this.height > x && this.y < y + width && this.y + this.width > y;
    }

    public IntPoint[] getEdgePoints() {
        IntPoint[] p = new IntPoint[]{new IntPoint(this.x, this.y), new IntPoint(this.x, this.y + this.width), new IntPoint(this.x + this.height, this.y), new IntPoint(this.x + this.height, this.y + this.width)};
        return p;
    }
}

