/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Parsers;

import Catalano.Imaging.FastBitmap;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;

public class GifEncoder {
    private int milliseconds;
    private final String saveFile;
    private boolean firstFrame = true;
    private ImageTypeSpecifier spec;
    private ImageWriter wr;

    public GifEncoder(String saveToFile) {
        this(saveToFile, 100);
    }

    public GifEncoder(String saveToFile, int milliseconds) {
        this.saveFile = saveToFile;
        this.milliseconds = milliseconds / 10;
    }

    public void addFrame(FastBitmap fastBitmap) {
        try {
            if (this.firstFrame) {
                this.firstFrame = false;
                this.spec = new ImageTypeSpecifier(fastBitmap.toBufferedImage());
                this.wr = ImageIO.getImageWriters(this.spec, "GIF").next();
                this.wr.setOutput(ImageIO.createImageOutputStream(new File(this.saveFile)));
                IIOMetadata metadata = this.getMetadata(this.wr, fastBitmap.toBufferedImage().getType(), this.milliseconds);
                this.wr.prepareWriteSequence(metadata);
                this.wr.writeToSequence(new IIOImage(fastBitmap.toBufferedImage(), null, metadata), null);
            }
            this.wr.writeToSequence(new IIOImage(fastBitmap.toBufferedImage(), null, null), null);
        }
        catch (IOException ex) {
            Logger.getLogger(GifEncoder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void finish() {
        try {
            this.firstFrame = true;
            this.wr.endWriteSequence();
            this.wr.dispose();
        }
        catch (IOException ex) {
            Logger.getLogger(GifEncoder.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private IIOMetadata getMetadata(ImageWriter writer, int type, int delay) throws IIOInvalidTreeException {
        ImageTypeSpecifier img_type = ImageTypeSpecifier.createFromBufferedImageType(type);
        IIOMetadata metadata = writer.getDefaultImageMetadata(img_type, null);
        String native_format = metadata.getNativeMetadataFormatName();
        IIOMetadataNode node_tree = (IIOMetadataNode)metadata.getAsTree(native_format);
        IIOMetadataNode graphics_node = this.getNode(node_tree, "GraphicControlExtension");
        graphics_node.setAttribute("delayTime", String.valueOf(delay));
        graphics_node.setAttribute("disposalMethod", "none");
        graphics_node.setAttribute("userInputFlag", "FALSE");
        metadata.setFromTree(native_format, node_tree);
        return metadata;
    }

    private IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
        int nNodes = rootNode.getLength();
        for (int i = 0; i < nNodes; ++i) {
            if (rootNode.item(i).getNodeName().compareToIgnoreCase(nodeName) != 0) continue;
            return (IIOMetadataNode)rootNode.item(i);
        }
        IIOMetadataNode node = new IIOMetadataNode(nodeName);
        rootNode.appendChild(node);
        return node;
    }
}

