/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Variance
implements IApplyInPlace {
    private int radius = 2;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public Variance() {
    }

    public Variance(int radius) {
        this.setRadius(radius);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int y;
        int x;
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        FastBitmap copy = new FastBitmap(fastBitmap);
        if (fastBitmap.isGrayscale()) {
            for (x = 0; x < height; ++x) {
                for (y = 0; y < width; ++y) {
                    int j;
                    int i;
                    double mean = 0.0;
                    double var = 0.0;
                    int total = 0;
                    for (i = x - this.radius; i <= x + this.radius; ++i) {
                        for (j = y - this.radius; j <= y + this.radius; ++j) {
                            if (i < 0 || i >= height || j < 0 || j >= width) continue;
                            mean += (double)copy.getGray(i, j);
                            ++total;
                        }
                    }
                    mean /= (double)total;
                    for (i = x - this.radius; i <= x + this.radius; ++i) {
                        for (j = y - this.radius; j <= y + this.radius; ++j) {
                            if (i < 0 || i >= height || j < 0 || j >= width) continue;
                            var += Math.pow((double)copy.getGray(i, j) - mean, 2.0);
                        }
                    }
                    if ((var /= (double)(total - 1)) < 0.0) {
                        var = 0.0;
                    }
                    if (var > 255.0) {
                        var = 255.0;
                    }
                    fastBitmap.setGray(x, y, (int)var);
                }
            }
        }
        if (fastBitmap.isRGB()) {
            for (x = 0; x < height; ++x) {
                for (y = 0; y < width; ++y) {
                    int j;
                    int i;
                    double meanR = 0.0;
                    double meanG = 0.0;
                    double meanB = 0.0;
                    double varR = 0.0;
                    double varG = 0.0;
                    double varB = 0.0;
                    int total = 0;
                    for (i = x - this.radius; i <= x + this.radius; ++i) {
                        for (j = y - this.radius; j <= y + this.radius; ++j) {
                            if (i < 0 || i >= height || j < 0 || j >= width) continue;
                            meanR += (double)copy.getRed(i, j);
                            meanG += (double)copy.getGreen(i, j);
                            meanB += (double)copy.getBlue(i, j);
                            ++total;
                        }
                    }
                    meanR /= (double)total;
                    meanG /= (double)total;
                    meanB /= (double)total;
                    for (i = x - this.radius; i <= x + this.radius; ++i) {
                        for (j = y - this.radius; j <= y + this.radius; ++j) {
                            if (i < 0 || i >= height || j < 0 || j >= width) continue;
                            varR += Math.pow((double)copy.getRed(i, j) - meanR, 2.0);
                            varG += Math.pow((double)copy.getGreen(i, j) - meanG, 2.0);
                            varB += Math.pow((double)copy.getBlue(i, j) - meanB, 2.0);
                        }
                    }
                    varR /= (double)(total - 1);
                    varG /= (double)(total - 1);
                    varB /= (double)(total - 1);
                    if (varR < 0.0) {
                        varR = 0.0;
                    }
                    if (varG < 0.0) {
                        varG = 0.0;
                    }
                    if (varB < 0.0) {
                        varB = 0.0;
                    }
                    if (varR > 255.0) {
                        varR = 255.0;
                    }
                    if (varG > 255.0) {
                        varG = 255.0;
                    }
                    if (varB > 255.0) {
                        varB = 255.0;
                    }
                    fastBitmap.setRGB(x, y, (int)varR, (int)varG, (int)varB);
                }
            }
        }
    }
}

