/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.FloatRange;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.HSLLinear;
import Catalano.Imaging.IApplyInPlace;

public class SaturationCorrection
implements IApplyInPlace {
    private HSLLinear baseFilter = new HSLLinear();
    private float adjustValue;

    public float getAdjustValue() {
        return this.adjustValue;
    }

    public void setAdjustValue(float value) {
        this.adjustValue = Math.max(-1.0f, Math.min(1.0f, value));
        if (this.adjustValue > 0.0f) {
            this.baseFilter.setInLuminance(new FloatRange(0.0f, 1.0f - this.adjustValue));
            this.baseFilter.setOutSaturation(new FloatRange(this.adjustValue, 1.0f));
        } else {
            this.baseFilter.setInSaturation(new FloatRange(-this.adjustValue, 1.0f));
            this.baseFilter.setOutSaturation(new FloatRange(0.0f, 1.0f + this.adjustValue));
        }
    }

    public SaturationCorrection() {
        this.setAdjustValue(0.1f);
    }

    public SaturationCorrection(float value) {
        this.setAdjustValue(value);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        this.baseFilter.applyInPlace(fastBitmap);
    }
}

