/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApply;
import Catalano.Imaging.IApplyInPlace;

public class RotateBilinear
implements IApply,
IApplyInPlace {
    private double angle;
    private boolean keepSize;
    private int newWidth;
    private int newHeight;
    private int fillRed = 0;
    private int fillGreen = 0;
    private int fillBlue = 0;
    private int fillGray = 0;

    public double getAngle() {
        return -this.angle;
    }

    public void setAngle(double angle) {
        this.angle = -angle;
    }

    public boolean isKeepSize() {
        return this.keepSize;
    }

    public void setKeepSize(boolean keepSize) {
        this.keepSize = keepSize;
    }

    public void setFillColor(int red, int green, int blue) {
        this.fillRed = red;
        this.fillGreen = green;
        this.fillBlue = blue;
    }

    public void setFillColor(int gray) {
        this.fillGray = gray;
    }

    public RotateBilinear(double angle) {
        this.angle = -angle;
        this.keepSize = false;
    }

    public RotateBilinear(double angle, boolean keepSize) {
        this.angle = -angle;
        this.keepSize = keepSize;
    }

    @Override
    public FastBitmap apply(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            double oldIradius = (double)(height - 1) / 2.0;
            double oldJradius = (double)(width - 1) / 2.0;
            this.CalculateNewSize(fastBitmap);
            FastBitmap destinationData = new FastBitmap(this.newWidth, this.newHeight, FastBitmap.ColorSpace.Grayscale);
            double newIradius = (double)(this.newHeight - 1) / 2.0;
            double newJradius = (double)(this.newWidth - 1) / 2.0;
            double angleRad = -this.angle * Math.PI / 180.0;
            double angleCos = Math.cos(angleRad);
            double angleSin = Math.sin(angleRad);
            int imax = height - 1;
            int jmax = width - 1;
            double ci = -newIradius;
            for (int i = 0; i < this.newHeight; ++i) {
                double ti = angleCos * ci + oldIradius;
                double tj = -angleSin * ci + oldJradius;
                double cj = -newJradius;
                for (int j = 0; j < this.newWidth; ++j) {
                    double oi = ti + angleSin * cj;
                    double oj = tj + angleCos * cj;
                    int oi1 = (int)oi;
                    int oj1 = (int)oj;
                    if (oi1 < 0 || oj1 < 0 || oi1 >= height || oj1 >= width) {
                        destinationData.setGray(i, j, this.fillGray);
                    } else {
                        double d;
                        double d2;
                        int oi2 = oi1 == imax ? oi1 : oi1 + 1;
                        int oj2 = oj1 == jmax ? oj1 : oj1 + 1;
                        double di1 = oi - (double)oi1;
                        if (d2 < 0.0) {
                            di1 = 0.0;
                        }
                        double di2 = 1.0 - di1;
                        double dj1 = oj - (double)oj1;
                        if (d < 0.0) {
                            dj1 = 0.0;
                        }
                        double dj2 = 1.0 - dj1;
                        int p1 = fastBitmap.getGray(oi1, oj1);
                        int p2 = fastBitmap.getGray(oi1, oj2);
                        int p3 = fastBitmap.getGray(oi2, oj1);
                        int p4 = fastBitmap.getGray(oi2, oj2);
                        int g = (int)(di2 * (dj2 * (double)p1 + dj1 * (double)p2) + di1 * (dj2 * (double)p3 + dj1 * (double)p4));
                        destinationData.setGray(i, j, g);
                    }
                    cj += 1.0;
                }
                ci += 1.0;
            }
            return destinationData;
        }
        if (fastBitmap.isRGB()) {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            double oldIradius = (double)(height - 1) / 2.0;
            double oldJradius = (double)(width - 1) / 2.0;
            this.CalculateNewSize(fastBitmap);
            FastBitmap destinationData = new FastBitmap(this.newWidth, this.newHeight, FastBitmap.ColorSpace.RGB);
            double newIradius = (double)(this.newHeight - 1) / 2.0;
            double newJradius = (double)(this.newWidth - 1) / 2.0;
            double angleRad = -this.angle * Math.PI / 180.0;
            double angleCos = Math.cos(angleRad);
            double angleSin = Math.sin(angleRad);
            int imax = height - 1;
            int jmax = width - 1;
            double ci = -newIradius;
            for (int i = 0; i < this.newHeight; ++i) {
                double ti = angleSin * ci + oldIradius;
                double tj = angleCos * ci + oldJradius;
                double cj = -newJradius;
                for (int j = 0; j < this.newWidth; ++j) {
                    double oi = ti + angleCos * cj;
                    double oj = tj - angleSin * cj;
                    int oi1 = (int)oi;
                    int oj1 = (int)oj;
                    if (oi1 < 0 || oj1 < 0 || oi1 >= height || oj1 >= width) {
                        destinationData.setRGB(i, j, this.fillRed, this.fillGreen, this.fillBlue);
                    } else {
                        double d;
                        double d3;
                        int oi2 = oi1 == imax ? oi1 : oi1 + 1;
                        int oj2 = oj1 == jmax ? oj1 : oj1 + 1;
                        double di1 = oi - (double)oi1;
                        if (d3 < 0.0) {
                            di1 = 0.0;
                        }
                        double di2 = 1.0 - di1;
                        double dj1 = oj - (double)oj1;
                        if (d < 0.0) {
                            dj1 = 0.0;
                        }
                        double dj2 = 1.0 - dj1;
                        int p1 = fastBitmap.getRed(oi1, oj1);
                        int p2 = fastBitmap.getRed(oi1, oj2);
                        int p3 = fastBitmap.getRed(oi2, oj1);
                        int p4 = fastBitmap.getRed(oi2, oj2);
                        int r = (int)(di2 * (dj2 * (double)p1 + dj1 * (double)p2) + di1 * (dj2 * (double)p3 + dj1 * (double)p4));
                        p1 = fastBitmap.getGreen(oi1, oj1);
                        p2 = fastBitmap.getGreen(oi1, oj2);
                        p3 = fastBitmap.getGreen(oi2, oj1);
                        p4 = fastBitmap.getGreen(oi2, oj2);
                        int g = (int)(di2 * (dj2 * (double)p1 + dj1 * (double)p2) + di1 * (dj2 * (double)p3 + dj1 * (double)p4));
                        p1 = fastBitmap.getBlue(oi1, oj1);
                        p2 = fastBitmap.getBlue(oi1, oj2);
                        p3 = fastBitmap.getBlue(oi2, oj1);
                        p4 = fastBitmap.getBlue(oi2, oj2);
                        int b = (int)(di2 * (dj2 * (double)p1 + dj1 * (double)p2) + di1 * (dj2 * (double)p3 + dj1 * (double)p4));
                        destinationData.setRGB(i, j, r, g, b);
                    }
                    cj += 1.0;
                }
                ci += 1.0;
            }
            return destinationData;
        }
        return null;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap temp = this.apply(fastBitmap);
        fastBitmap.setImage(temp);
    }

    private void CalculateNewSize(FastBitmap fastBitmap) {
        if (this.keepSize) {
            this.newWidth = fastBitmap.getWidth();
            this.newHeight = fastBitmap.getHeight();
            return;
        }
        double angleRad = -this.angle * Math.PI / 180.0;
        double angleCos = Math.cos(angleRad);
        double angleSin = Math.sin(angleRad);
        double halfWidth = (double)fastBitmap.getWidth() / 2.0;
        double halfHeight = (double)fastBitmap.getHeight() / 2.0;
        double cx1 = halfWidth * angleCos;
        double cy1 = halfWidth * angleSin;
        double cx2 = halfWidth * angleCos - halfHeight * angleSin;
        double cy2 = halfWidth * angleSin + halfHeight * angleCos;
        double cx3 = -halfHeight * angleSin;
        double cy3 = halfHeight * angleCos;
        double cx4 = 0.0;
        double cy4 = 0.0;
        halfWidth = Math.max(Math.max(cx1, cx2), Math.max(cx3, cx4)) - Math.min(Math.min(cx1, cx2), Math.min(cx3, cx4));
        halfHeight = Math.max(Math.max(cy1, cy2), Math.max(cy3, cy4)) - Math.min(Math.min(cy1, cy2), Math.min(cy3, cy4));
        this.newWidth = (int)(halfWidth * 2.0 + 0.5);
        this.newHeight = (int)(halfHeight * 2.0 + 0.5);
    }
}

