/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Convolution;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.CompassConvolutionKernel;

public class PrewittCompassEdgeDetector
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int j;
        int i;
        int[][] prewitt;
        Object image;
        int width;
        int height;
        Convolution c = new Convolution();
        FastBitmap copy = new FastBitmap(fastBitmap);
        if (fastBitmap.isGrayscale()) {
            height = fastBitmap.getHeight();
            width = fastBitmap.getWidth();
            image = new int[height][width];
            prewitt = CompassConvolutionKernel.Prewitt_North;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = copy.getGray(i, j);
                }
            }
            copy = new FastBitmap(fastBitmap);
            prewitt = CompassConvolutionKernel.Prewitt_Northwest;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            prewitt = CompassConvolutionKernel.Prewitt_West;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            prewitt = CompassConvolutionKernel.Prewitt_Southwest;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            prewitt = CompassConvolutionKernel.Prewitt_South;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            prewitt = CompassConvolutionKernel.Prewitt_Southeast;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            prewitt = CompassConvolutionKernel.Prewitt_East;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            prewitt = CompassConvolutionKernel.Prewitt_Northeast;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            fastBitmap.matrixToImage((int[][])image);
        }
        if (fastBitmap.isRGB()) {
            height = fastBitmap.getHeight();
            width = fastBitmap.getWidth();
            image = new int[height][width][3];
            prewitt = CompassConvolutionKernel.Prewitt_North;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = copy.getRed(i, j);
                    image[i][j][1] = copy.getGreen(i, j);
                    image[i][j][2] = copy.getBlue(i, j);
                }
            }
            copy = new FastBitmap(fastBitmap);
            prewitt = CompassConvolutionKernel.Prewitt_Northwest;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            prewitt = CompassConvolutionKernel.Prewitt_West;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            prewitt = CompassConvolutionKernel.Prewitt_Southwest;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            prewitt = CompassConvolutionKernel.Prewitt_South;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            prewitt = CompassConvolutionKernel.Prewitt_Southeast;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            prewitt = CompassConvolutionKernel.Prewitt_East;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            prewitt = CompassConvolutionKernel.Prewitt_Northeast;
            c.setKernel(prewitt);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            fastBitmap.matrixToImage((int[][][])image);
        }
    }
}

