/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class MeanShift
implements IApplyInPlace {
    private int radius;
    private float colorDistance;

    public MeanShift() {
    }

    public MeanShift(int radius, float colorDistance) {
        this.radius = radius;
        this.colorDistance = colorDistance;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        if (fastBitmap.isRGB()) {
            float[][][] pixelsF = new float[height][width][3];
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    int r = fastBitmap.getRed(x, y);
                    int g = fastBitmap.getGreen(x, y);
                    int b = fastBitmap.getBlue(x, y);
                    pixelsF[x][y][0] = 0.299f * (float)r + 0.587f * (float)g + 0.114f * (float)b;
                    pixelsF[x][y][1] = 0.5957f * (float)r - 0.2744f * (float)g - 0.3212f * (float)b;
                    pixelsF[x][y][2] = 0.2114f * (float)r - 0.5226f * (float)g + 0.3111f * (float)b;
                }
            }
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    float QcOld;
                    float mQ;
                    float dQ;
                    float IcOld;
                    float mI;
                    float dI;
                    float YcOld;
                    float mY;
                    float dY;
                    int ycOld;
                    float my;
                    int dy;
                    int xcOld;
                    int num;
                    float num_;
                    float mx;
                    int dx;
                    float shift;
                    int yc = y;
                    int xc = x;
                    float[] yiq = pixelsF[x][y];
                    float Yc = yiq[0];
                    float Ic = yiq[1];
                    float Qc = yiq[2];
                    int iters = 0;
                    do {
                        xcOld = xc;
                        ycOld = yc;
                        YcOld = Yc;
                        IcOld = Ic;
                        QcOld = Qc;
                        mx = 0.0f;
                        my = 0.0f;
                        mY = 0.0f;
                        mI = 0.0f;
                        mQ = 0.0f;
                        num = 0;
                        int radius2 = this.radius * this.radius;
                        float colorDistance2 = this.colorDistance * this.colorDistance;
                        for (int rx = -this.radius; rx <= this.radius; ++rx) {
                            int x2 = xc + rx;
                            if (x2 < 0 || x2 >= height) continue;
                            for (int ry = -this.radius; ry <= this.radius; ++ry) {
                                float Q2;
                                float dQ2;
                                float I2;
                                float dI2;
                                float Y2;
                                float dY2;
                                int y2 = yc + ry;
                                if (y2 < 0 || y2 >= width || rx * rx + ry * ry > radius2 || !((dY2 = Yc - (Y2 = (yiq = pixelsF[x2][y2])[0])) * dY2 + (dI2 = Ic - (I2 = yiq[1])) * dI2 + (dQ2 = Qc - (Q2 = yiq[2])) * dQ2 <= colorDistance2)) continue;
                                mx += (float)x2;
                                my += (float)y2;
                                mY += Y2;
                                mI += I2;
                                mQ += Q2;
                                ++num;
                            }
                        }
                    } while ((shift = (float)((dx = (xc = (int)((double)(mx * (num_ = 1.0f / (float)num)) + 0.5)) - xcOld) * dx + (dy = (yc = (int)((double)(my * num_) + 0.5)) - ycOld) * dy) + (dY = (Yc = mY * num_) - YcOld) * dY + (dI = (Ic = mI * num_) - IcOld) * dI + (dQ = (Qc = mQ * num_) - QcOld) * dQ) > 3.0f && ++iters < 100);
                    int r_ = (int)(Yc + 0.9563f * Ic + 0.621f * Qc);
                    int g_ = (int)(Yc - 0.2721f * Ic - 0.6473f * Qc);
                    int b_ = (int)(Yc - 1.107f * Ic + 1.7046f * Qc);
                    fastBitmap.setRGB(x, y, r_, g_, b_);
                }
            }
        }
        if (fastBitmap.isGrayscale()) {
            for (int x = 0; x < height; ++x) {
                for (int y = 0; y < width; ++y) {
                    float YcOld;
                    float mY;
                    float dY;
                    int ycOld;
                    float my;
                    int dy;
                    int xcOld;
                    int num;
                    float num_;
                    float mx;
                    int dx;
                    float shift;
                    int yc = y;
                    int xc = x;
                    float Yc = fastBitmap.getGray(x, y);
                    int iters = 0;
                    do {
                        xcOld = xc;
                        ycOld = yc;
                        YcOld = Yc;
                        mx = 0.0f;
                        my = 0.0f;
                        mY = 0.0f;
                        num = 0;
                        int radius2 = this.radius * this.radius;
                        float colorDistance2 = this.colorDistance * this.colorDistance;
                        for (int rx = -this.radius; rx <= this.radius; ++rx) {
                            int x2 = xc + rx;
                            if (x2 < 0 || x2 >= height) continue;
                            for (int ry = -this.radius; ry <= this.radius; ++ry) {
                                float Y2;
                                float dY3;
                                int y2 = yc + ry;
                                if (y2 < 0 || y2 >= width || rx * rx + ry * ry > radius2 || !((dY3 = Yc - (Y2 = (float)fastBitmap.getGray(x2, y2))) * dY3 <= colorDistance2)) continue;
                                mx += (float)x2;
                                my += (float)y2;
                                mY += Y2;
                                ++num;
                            }
                        }
                    } while ((shift = (float)((dx = (xc = (int)((double)(mx * (num_ = 1.0f / (float)num)) + 0.5)) - xcOld) * dx + (dy = (yc = (int)((double)(my * num_) + 0.5)) - ycOld) * dy) + (dY = (Yc = mY * num_) - YcOld) * dY) > 3.0f && ++iters < 100);
                    fastBitmap.setGray(x, y, (int)Yc);
                }
            }
        }
    }
}

