/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Kuwahara
implements IApplyInPlace {
    private int windowSize = 5;

    public Kuwahara() {
    }

    public Kuwahara(int windowSize) {
        this.windowSize = Math.max(windowSize, 5);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        block31: {
            FastBitmap copy;
            int offset;
            int size2;
            int height;
            int width;
            block30: {
                int b;
                int g;
                int r;
                width = fastBitmap.getWidth();
                height = fastBitmap.getHeight();
                size2 = (this.windowSize + 1) / 2;
                offset = (this.windowSize - 1) / 2;
                copy = new FastBitmap(fastBitmap);
                if (!fastBitmap.isRGB()) break block30;
                int width2 = width + offset;
                int height2 = height + offset;
                float[][][] mean = new float[width2][height2][3];
                float[][][] variance = new float[width2][height2][3];
                for (int y1 = 0 - offset; y1 < 0 + height; ++y1) {
                    for (int x1 = 0 - offset; x1 < 0 + width; ++x1) {
                        double sumB = 0.0;
                        double sumG = 0.0;
                        double sumR = 0.0;
                        double sum2B = 0.0;
                        double sum2G = 0.0;
                        double sum2R = 0.0;
                        int n = 0;
                        for (int x2 = x1; x2 < x1 + size2; ++x2) {
                            for (int y2 = y1; y2 < y1 + size2; ++y2) {
                                if (x2 > 0 && x2 < width && y2 > 0 && y2 < height) {
                                    r = copy.getRed(y2, x2);
                                    g = copy.getGreen(y2, x2);
                                    b = copy.getBlue(y2, x2);
                                    sumR += (double)r;
                                    sum2R += (double)(r * r);
                                    sumG += (double)g;
                                    sum2G += (double)(g * g);
                                    sumB += (double)b;
                                    sum2B += (double)(b * b);
                                    ++n;
                                    continue;
                                }
                                ++n;
                            }
                        }
                        mean[x1 + offset][y1 + offset][0] = (float)(sumR / (double)n);
                        mean[x1 + offset][y1 + offset][1] = (float)(sumG / (double)n);
                        mean[x1 + offset][y1 + offset][2] = (float)(sumB / (double)n);
                        variance[x1 + offset][y1 + offset][0] = (float)(sum2R - sumR * sumR / (double)n);
                        variance[x1 + offset][y1 + offset][1] = (float)(sum2G - sumG * sumG / (double)n);
                        variance[x1 + offset][y1 + offset][2] = (float)(sum2B - sumB * sumB / (double)n);
                    }
                }
                int xbase2 = 0;
                int ybase2 = 0;
                for (int y1 = 0; y1 < 0 + height; ++y1) {
                    for (int x1 = 0; x1 < 0 + width; ++x1) {
                        int xbase = x1;
                        int ybase = y1;
                        float var = variance[xbase][ybase][0];
                        float min = Float.MAX_VALUE;
                        if (var < min) {
                            min = var;
                            xbase2 = xbase;
                            ybase2 = ybase;
                        }
                        if ((var = variance[xbase = x1 + offset][ybase][0]) < min) {
                            min = var;
                            xbase2 = xbase;
                            ybase2 = ybase;
                        }
                        if ((var = variance[xbase][ybase = y1 + offset][0]) < min) {
                            min = var;
                            xbase2 = xbase;
                            ybase2 = ybase;
                        }
                        if ((var = variance[xbase = x1][ybase][0]) < min) {
                            min = var;
                            xbase2 = xbase;
                            ybase2 = ybase;
                        }
                        r = (int)((double)mean[xbase2][ybase2][0] + 0.5);
                        xbase = x1;
                        ybase = y1;
                        var = variance[xbase][ybase][1];
                        min = Float.MAX_VALUE;
                        if (var < min) {
                            min = var;
                            xbase2 = xbase;
                            ybase2 = ybase;
                        }
                        if ((var = variance[xbase = x1 + offset][ybase][1]) < min) {
                            min = var;
                            xbase2 = xbase;
                            ybase2 = ybase;
                        }
                        if ((var = variance[xbase][ybase = y1 + offset][1]) < min) {
                            min = var;
                            xbase2 = xbase;
                            ybase2 = ybase;
                        }
                        if ((var = variance[xbase = x1][ybase][1]) < min) {
                            min = var;
                            xbase2 = xbase;
                            ybase2 = ybase;
                        }
                        g = (int)((double)mean[xbase2][ybase2][1] + 0.5);
                        xbase = x1;
                        ybase = y1;
                        var = variance[xbase][ybase][2];
                        min = Float.MAX_VALUE;
                        if (var < min) {
                            min = var;
                            xbase2 = xbase;
                            ybase2 = ybase;
                        }
                        if ((var = variance[xbase = x1 + offset][ybase][2]) < min) {
                            min = var;
                            xbase2 = xbase;
                            ybase2 = ybase;
                        }
                        if ((var = variance[xbase][ybase = y1 + offset][2]) < min) {
                            min = var;
                            xbase2 = xbase;
                            ybase2 = ybase;
                        }
                        if ((var = variance[xbase = x1][ybase][2]) < min) {
                            min = var;
                            xbase2 = xbase;
                            ybase2 = ybase;
                        }
                        b = (int)((double)mean[xbase2][ybase2][2] + 0.5);
                        fastBitmap.setRGB(y1, x1, r, g, b);
                    }
                }
                break block31;
            }
            if (!fastBitmap.isGrayscale()) break block31;
            int width2 = width + offset;
            int height2 = height + offset;
            float[][] mean = new float[width2][height2];
            float[][] variance = new float[width2][height2];
            int v = 0;
            for (int y1 = 0 - offset; y1 < 0 + height; ++y1) {
                for (int x1 = 0 - offset; x1 < 0 + width; ++x1) {
                    double sum = 0.0;
                    double sum2 = 0.0;
                    int n = 0;
                    for (int x2 = x1; x2 < x1 + size2; ++x2) {
                        for (int y2 = y1; y2 < y1 + size2; ++y2) {
                            if (x2 > 0 && x2 < width && y2 > 0 && y2 < height) {
                                v = copy.getGray(y2, x2);
                                sum += (double)v;
                                sum2 += (double)(v * v);
                                ++n;
                                continue;
                            }
                            v = 0;
                            sum += (double)v;
                            sum2 += (double)(v * v);
                            ++n;
                        }
                    }
                    mean[x1 + offset][y1 + offset] = (float)(sum / (double)n);
                    variance[x1 + offset][y1 + offset] = (float)(sum2 - sum * sum / (double)n);
                }
            }
            int xbase2 = 0;
            int ybase2 = 0;
            for (int y1 = 0; y1 < 0 + height; ++y1) {
                for (int x1 = 0; x1 < 0 + width; ++x1) {
                    int xbase = x1;
                    int ybase = y1;
                    float var = variance[xbase][ybase];
                    float min = Float.MAX_VALUE;
                    if (var < min) {
                        min = var;
                        xbase2 = xbase;
                        ybase2 = ybase;
                    }
                    if ((var = variance[xbase = x1 + offset][ybase]) < min) {
                        min = var;
                        xbase2 = xbase;
                        ybase2 = ybase;
                    }
                    if ((var = variance[xbase][ybase = y1 + offset]) < min) {
                        min = var;
                        xbase2 = xbase;
                        ybase2 = ybase;
                    }
                    if ((var = variance[xbase = x1][ybase]) < min) {
                        min = var;
                        xbase2 = xbase;
                        ybase2 = ybase;
                    }
                    fastBitmap.setGray(y1, x1, (int)((double)mean[xbase2][ybase2] + 0.5));
                }
            }
        }
    }
}

