/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Convolution;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.CompassConvolutionKernel;

public class KirschCompassEdgeDetector
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int j;
        int i;
        int[][] kirsch;
        Object image;
        int width;
        int height;
        Convolution c = new Convolution();
        FastBitmap copy = new FastBitmap(fastBitmap);
        if (fastBitmap.isGrayscale()) {
            height = fastBitmap.getHeight();
            width = fastBitmap.getWidth();
            image = new int[height][width];
            kirsch = CompassConvolutionKernel.Kirsch_North;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = copy.getGray(i, j);
                }
            }
            copy = new FastBitmap(fastBitmap);
            kirsch = CompassConvolutionKernel.Kirsch_Northwest;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            kirsch = CompassConvolutionKernel.Kirsch_West;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            kirsch = CompassConvolutionKernel.Kirsch_Southwest;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            kirsch = CompassConvolutionKernel.Kirsch_South;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            kirsch = CompassConvolutionKernel.Kirsch_Southeast;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            kirsch = CompassConvolutionKernel.Kirsch_East;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            kirsch = CompassConvolutionKernel.Kirsch_Northeast;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j] = Math.max(image[i][j], copy.getGray(i, j));
                }
            }
            fastBitmap.matrixToImage((int[][])image);
        }
        if (fastBitmap.isRGB()) {
            height = fastBitmap.getHeight();
            width = fastBitmap.getWidth();
            image = new int[height][width][3];
            kirsch = CompassConvolutionKernel.Kirsch_North;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = copy.getRed(i, j);
                    image[i][j][1] = copy.getGreen(i, j);
                    image[i][j][2] = copy.getBlue(i, j);
                }
            }
            copy = new FastBitmap(fastBitmap);
            kirsch = CompassConvolutionKernel.Kirsch_Northwest;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            kirsch = CompassConvolutionKernel.Kirsch_West;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            kirsch = CompassConvolutionKernel.Kirsch_Southwest;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            kirsch = CompassConvolutionKernel.Kirsch_South;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            kirsch = CompassConvolutionKernel.Kirsch_Southeast;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            kirsch = CompassConvolutionKernel.Kirsch_East;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            copy = new FastBitmap(fastBitmap);
            kirsch = CompassConvolutionKernel.Kirsch_Northeast;
            c.setKernel(kirsch);
            c.applyInPlace(copy);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    image[i][j][0] = Math.max((int)image[i][j][0], copy.getRed(i, j));
                    image[i][j][1] = Math.max((int)image[i][j][1], copy.getGreen(i, j));
                    image[i][j][2] = Math.max((int)image[i][j][2], copy.getBlue(i, j));
                }
            }
            fastBitmap.matrixToImage((int[][][])image);
        }
    }
}

