/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class HysteresisThreshold
implements IApplyInPlace {
    int lowThreshold = 20;
    int highThreshold = 100;

    public int getLowThreshold() {
        return this.lowThreshold;
    }

    public void setLowThreshold(int lowThreshold) {
        this.lowThreshold = lowThreshold;
    }

    public int getHighThreshold() {
        return this.highThreshold;
    }

    public void setHighThreshold(int highThreshold) {
        this.highThreshold = highThreshold;
    }

    public HysteresisThreshold() {
    }

    public HysteresisThreshold(int lowThreshold, int highThreshold) {
        this.lowThreshold = lowThreshold;
        this.highThreshold = highThreshold;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            for (int i = 1; i < height - 1; ++i) {
                for (int j = 1; j < width - 1; ++j) {
                    if (fastBitmap.getGray(i, j) >= this.highThreshold) continue;
                    if (fastBitmap.getGray(i, j) < this.lowThreshold) {
                        fastBitmap.setGray(i, j, 0);
                        continue;
                    }
                    if (fastBitmap.getGray(i, j - 1) >= this.highThreshold || fastBitmap.getGray(i, j + 1) >= this.highThreshold || fastBitmap.getGray(i - 1, j - 1) >= this.highThreshold || fastBitmap.getGray(i - 1, j) >= this.highThreshold || fastBitmap.getGray(i - 1, j + 1) >= this.highThreshold || fastBitmap.getGray(i + 1, j - 1) >= this.highThreshold || fastBitmap.getGray(i + 1, j) >= this.highThreshold || fastBitmap.getGray(i + 1, j + 1) >= this.highThreshold) continue;
                    fastBitmap.setGray(i, j, 0);
                }
            }
        } else {
            throw new IllegalArgumentException("Hysteresis Threshold only works with grayscale images.");
        }
    }
}

