/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class HorizontalRunLengthSmoothing
implements IApplyInPlace {
    private int maxGapSize = 10;
    private boolean processGapsWithImageBorders = false;

    public int getMaxGapSize() {
        return this.maxGapSize;
    }

    public void setMaxGapSize(int maxGapSize) {
        this.maxGapSize = Math.max(1, Math.min(1000, maxGapSize));
    }

    public boolean isProcessGapsWithImageBorders() {
        return this.processGapsWithImageBorders;
    }

    public void setProcessGapsWithImageBorders(boolean processGapsWithImageBorders) {
        this.processGapsWithImageBorders = processGapsWithImageBorders;
    }

    public HorizontalRunLengthSmoothing() {
    }

    public HorizontalRunLengthSmoothing(int maxGapSize) {
        this.setMaxGapSize(maxGapSize);
    }

    public HorizontalRunLengthSmoothing(int maxGapSize, boolean processGapsWithImageBorders) {
        this.setMaxGapSize(maxGapSize);
        this.setProcessGapsWithImageBorders(processGapsWithImageBorders);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            for (int i = 0; i < height; ++i) {
                int position;
                int lineStart = position = 0;
                int lineEndPtr = width;
                while (position < lineEndPtr) {
                    int gapStart = position;
                    while (position < lineEndPtr && fastBitmap.getGray(i, position) == 0) {
                        ++position;
                    }
                    if (position - gapStart <= this.maxGapSize && (this.processGapsWithImageBorders || gapStart != lineStart && position != lineEndPtr)) {
                        while (gapStart < position) {
                            fastBitmap.setGray(i, gapStart, 255);
                            ++gapStart;
                        }
                    }
                    while (position < lineEndPtr && fastBitmap.getGray(i, position) != 0) {
                        ++position;
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("HorizontalRunLengthSmoothing only works in grayscale images.");
        }
    }
}

