/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Math.Matrix;

public class EnsembleThreshold
implements IApplyInPlace {
    private int[] threshold;
    private boolean invert;

    public int[] getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int[] threshold) {
        this.threshold = threshold;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public EnsembleThreshold(int[] threshold) {
        this(threshold, false);
    }

    public EnsembleThreshold(int[] threshold, boolean invert) {
        this.threshold = threshold;
        this.invert = invert;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                int g = fastBitmap.getGray(i);
                int[] map = new int[2];
                for (int j = 0; j < this.threshold.length; ++j) {
                    if (!this.invert) {
                        if (g >= this.threshold[j]) {
                            map[1] = map[1] + 1;
                            continue;
                        }
                        map[0] = map[0] + 1;
                        continue;
                    }
                    if (g >= this.threshold[j]) {
                        map[0] = map[0] + 1;
                        continue;
                    }
                    map[1] = map[1] + 1;
                }
                int index = Matrix.MaxIndex(map);
                if (index == 0) {
                    fastBitmap.setGray(i, 0);
                    continue;
                }
                fastBitmap.setGray(i, 255);
            }
        } else {
            throw new IllegalArgumentException("Ensemble Threshold only works in grayscale images.");
        }
    }
}

