/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Dilatation
implements IApplyInPlace {
    private int radius = 0;
    private int[][] kernel;

    public Dilatation() {
        this.radius = 1;
    }

    public Dilatation(int radius) {
        this.radius = Math.max(radius, 1);
    }

    public Dilatation(int[][] kernel) {
        this.kernel = kernel;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int Y;
        int X;
        int j;
        int i;
        FastBitmap copy;
        int radiusJ;
        int radiusI;
        int height = fastBitmap.getHeight();
        int width = fastBitmap.getWidth();
        if (fastBitmap.isGrayscale()) {
            if (this.kernel == null) {
                this.createKernel(this.radius);
            }
            radiusI = (this.kernel.length - 1) / 2;
            radiusJ = (this.kernel[0].length - 1) / 2;
            copy = new FastBitmap(fastBitmap);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    X = 0;
                    int max = 0;
                    for (int x = i - radiusI; x < i + radiusI + 1; ++x) {
                        Y = 0;
                        for (int y = j - radiusJ; y < j + radiusJ + 1; ++y) {
                            int val;
                            if (x >= 0 && x < height && y >= 0 && y < width && (val = copy.getGray(x, y) + this.kernel[X][Y]) > max) {
                                max = val;
                            }
                            ++Y;
                        }
                        ++X;
                    }
                    max = max > 255 ? 255 : max;
                    fastBitmap.setGray(i, j, max);
                }
            }
        }
        if (fastBitmap.isRGB()) {
            if (this.kernel == null) {
                this.createKernel(this.radius);
            }
            radiusI = (this.kernel.length - 1) / 2;
            radiusJ = (this.kernel[0].length - 1) / 2;
            copy = new FastBitmap(fastBitmap);
            for (i = 0; i < height; ++i) {
                for (j = 0; j < width; ++j) {
                    X = 0;
                    int maxR = 0;
                    int maxG = 0;
                    int maxB = 0;
                    for (int x = i - radiusI; x < i + radiusI + 1; ++x) {
                        Y = 0;
                        for (int y = j - radiusJ; y < j + radiusJ + 1; ++y) {
                            if (x >= 0 && x < height && y >= 0 && y < width) {
                                int valR = copy.getRed(x, y) + this.kernel[X][Y];
                                int valG = copy.getGreen(x, y) + this.kernel[X][Y];
                                int valB = copy.getBlue(x, y) + this.kernel[X][Y];
                                if (valR > maxR) {
                                    maxR = valR;
                                }
                                if (valG > maxG) {
                                    maxG = valG;
                                }
                                if (valB > maxB) {
                                    maxB = valB;
                                }
                            }
                            ++Y;
                        }
                        ++X;
                    }
                    maxR = maxR > 255 ? 255 : maxR;
                    maxG = maxG > 255 ? 255 : maxG;
                    maxB = maxB > 255 ? 255 : maxB;
                    fastBitmap.setRGB(i, j, maxR, maxG, maxB);
                }
            }
        }
    }

    private void createKernel(int radius) {
        int size = radius * 2 + 1;
        this.kernel = new int[size][size];
        for (int i = 0; i < this.kernel.length; ++i) {
            for (int j = 0; j < this.kernel[0].length; ++j) {
                this.kernel[i][j] = 1;
            }
        }
    }
}

