/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Closing;
import Catalano.Imaging.Filters.Subtract;
import Catalano.Imaging.IApplyInPlace;

public class BottomHat
implements IApplyInPlace {
    private int[][] kernel;
    private int radius;

    public BottomHat() {
        this.radius = 1;
    }

    public BottomHat(int[][] se) {
        this.kernel = se;
    }

    public BottomHat(int radius) {
        this.radius = radius = radius < 1 ? 1 : radius;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (this.radius != 0) {
            this.ApplyInPlace(fastBitmap, this.radius);
        } else {
            this.ApplyInPlace(fastBitmap, this.kernel);
        }
    }

    private void ApplyInPlace(FastBitmap fastBitmap, int radius) {
        FastBitmap l = new FastBitmap(fastBitmap);
        Closing close = new Closing(radius);
        close.applyInPlace(l);
        Subtract sub = new Subtract(fastBitmap);
        sub.applyInPlace(l);
        fastBitmap.setImage(l);
    }

    private void ApplyInPlace(FastBitmap fastBitmap, int[][] se) {
        FastBitmap l = new FastBitmap(fastBitmap);
        Closing close = new Closing(se);
        close.applyInPlace(l);
        Subtract sub = new Subtract(l);
        sub.applyInPlace(fastBitmap);
        fastBitmap.setImage(l);
    }
}

