/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Artistic;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Blend
implements IApplyInPlace {
    private Algorithm algorithm;
    private FastBitmap overlay;

    public FastBitmap getOverlay() {
        return this.overlay;
    }

    public void setOverlay(FastBitmap overlay) {
        this.overlay = overlay;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public Blend(FastBitmap overlay, Algorithm algorithm) {
        this.overlay = overlay;
        this.algorithm = algorithm;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        block116: {
            block115: {
                if (!fastBitmap.isRGB() || !this.overlay.isRGB()) break block115;
                int size = fastBitmap.getWidth() * fastBitmap.getHeight();
                switch (this.algorithm) {
                    case Lighten: {
                        for (int i = 0; i < size; ++i) {
                            if (this.overlay.getRed(i) > fastBitmap.getRed(i)) {
                                fastBitmap.setRed(i, this.overlay.getRed(i));
                            }
                            if (this.overlay.getGreen(i) > fastBitmap.getGreen(i)) {
                                fastBitmap.setGreen(i, this.overlay.getGreen(i));
                            }
                            if (this.overlay.getBlue(i) <= fastBitmap.getBlue(i)) continue;
                            fastBitmap.setBlue(i, this.overlay.getBlue(i));
                        }
                        break block116;
                    }
                    case Darken: {
                        for (int i = 0; i < size; ++i) {
                            if (this.overlay.getRed(i) < fastBitmap.getRed(i)) {
                                fastBitmap.setRed(i, this.overlay.getRed(i));
                            }
                            if (this.overlay.getGreen(i) < fastBitmap.getGreen(i)) {
                                fastBitmap.setGreen(i, this.overlay.getGreen(i));
                            }
                            if (this.overlay.getBlue(i) >= fastBitmap.getBlue(i)) continue;
                            fastBitmap.setBlue(i, this.overlay.getBlue(i));
                        }
                        break block116;
                    }
                    case Multiply: {
                        for (int i = 0; i < size; ++i) {
                            int r = fastBitmap.getRed(i) * this.overlay.getRed(i) / 255;
                            int g = fastBitmap.getGreen(i) * this.overlay.getGreen(i) / 255;
                            int b = fastBitmap.getBlue(i) * this.overlay.getBlue(i) / 255;
                            fastBitmap.setRGB(i, r, g, b);
                        }
                        break block116;
                    }
                    case Average: {
                        for (int i = 0; i < size; ++i) {
                            int r = fastBitmap.getRed(i) * this.overlay.getRed(i) / 2;
                            int g = fastBitmap.getGreen(i) * this.overlay.getGreen(i) / 2;
                            int b = fastBitmap.getBlue(i) * this.overlay.getBlue(i) / 2;
                            fastBitmap.setRGB(i, r, g, b);
                        }
                        break block116;
                    }
                    case Add: {
                        for (int i = 0; i < size; ++i) {
                            int r = Math.min(fastBitmap.getRed(i) + this.overlay.getRed(i), 255);
                            int g = Math.min(fastBitmap.getGreen(i) + this.overlay.getGreen(i), 255);
                            int b = Math.min(fastBitmap.getBlue(i) + this.overlay.getBlue(i), 255);
                            fastBitmap.setRGB(i, r, g, b);
                        }
                        break block116;
                    }
                    case Subtract: {
                        for (int i = 0; i < size; ++i) {
                            int temp = fastBitmap.getRed(i) + this.overlay.getRed(i);
                            if (temp < 255) {
                                fastBitmap.setRed(i, 0);
                            } else {
                                fastBitmap.setRed(i, temp - 255);
                            }
                            temp = fastBitmap.getGreen(i) + this.overlay.getGreen(i);
                            if (temp < 255) {
                                fastBitmap.setGreen(i, 0);
                            } else {
                                fastBitmap.setGreen(i, temp - 255);
                            }
                            temp = fastBitmap.getBlue(i) + this.overlay.getBlue(i);
                            if (temp < 255) {
                                fastBitmap.setBlue(i, 0);
                                continue;
                            }
                            fastBitmap.setBlue(i, temp - 255);
                        }
                        break block116;
                    }
                    case Difference: {
                        for (int i = 0; i < size; ++i) {
                            int r = Math.abs(fastBitmap.getRed(i) - this.overlay.getRed(i));
                            int g = Math.abs(fastBitmap.getGreen(i) - this.overlay.getGreen(i));
                            int b = Math.abs(fastBitmap.getBlue(i) - this.overlay.getBlue(i));
                            fastBitmap.setRGB(i, r, g, b);
                        }
                        break block116;
                    }
                    case Negation: {
                        for (int i = 0; i < size; ++i) {
                            int r = 255 - Math.abs(255 - fastBitmap.getRed(i) - this.overlay.getRed(i));
                            int g = 255 - Math.abs(255 - fastBitmap.getGreen(i) - this.overlay.getGreen(i));
                            int b = 255 - Math.abs(255 - fastBitmap.getBlue(i) - this.overlay.getBlue(i));
                            fastBitmap.setRGB(i, r, g, b);
                        }
                        break block116;
                    }
                    case Screen: {
                        for (int i = 0; i < size; ++i) {
                            int r = 255 - ((255 - fastBitmap.getRed(i)) * (255 - this.overlay.getRed(i)) >> 8);
                            int g = 255 - ((255 - fastBitmap.getGreen(i)) * (255 - this.overlay.getGreen(i)) >> 8);
                            int b = 255 - ((255 - fastBitmap.getBlue(i)) * (255 - this.overlay.getBlue(i)) >> 8);
                            fastBitmap.setRGB(i, r, g, b);
                        }
                        break block116;
                    }
                    case Exclusion: {
                        for (int i = 0; i < size; ++i) {
                            int r = fastBitmap.getRed(i) + this.overlay.getRed(i) - 2 * fastBitmap.getRed(i) * this.overlay.getRed(i) / 255;
                            int g = fastBitmap.getGreen(i) + this.overlay.getGreen(i) - 2 * fastBitmap.getGreen(i) * this.overlay.getGreen(i) / 255;
                            int b = fastBitmap.getBlue(i) + this.overlay.getBlue(i) - 2 * fastBitmap.getBlue(i) * this.overlay.getBlue(i) / 255;
                            fastBitmap.setRGB(i, r, g, b);
                        }
                        break block116;
                    }
                    case Overlay: {
                        for (int i = 0; i < size; ++i) {
                            int temp;
                            if (this.overlay.getRed(i) < 128) {
                                temp = 2 * fastBitmap.getRed(i) * this.overlay.getRed(i) / 255;
                                temp = Math.min(255, temp);
                                fastBitmap.setRed(i, temp);
                            } else {
                                temp = 255 - 2 * (255 - fastBitmap.getRed(i)) * (255 - this.overlay.getRed(i)) / 255;
                                temp = Math.min(255, temp);
                                fastBitmap.setRed(i, temp);
                            }
                            if (this.overlay.getGreen(i) < 128) {
                                temp = 2 * fastBitmap.getGreen(i) * this.overlay.getGreen(i) / 255;
                                temp = Math.min(255, temp);
                                fastBitmap.setGreen(i, temp);
                            } else {
                                temp = 255 - 2 * (255 - fastBitmap.getGreen(i)) * (255 - this.overlay.getGreen(i)) / 255;
                                temp = Math.min(255, temp);
                                fastBitmap.setGreen(i, temp);
                            }
                            if (this.overlay.getBlue(i) < 128) {
                                temp = 2 * fastBitmap.getBlue(i) * this.overlay.getBlue(i) / 255;
                                temp = Math.min(255, temp);
                                fastBitmap.setBlue(i, temp);
                                continue;
                            }
                            temp = 255 - 2 * (255 - fastBitmap.getBlue(i)) * (255 - this.overlay.getBlue(i)) / 255;
                            temp = Math.min(255, temp);
                            fastBitmap.setBlue(i, temp);
                        }
                        break block116;
                    }
                    case SoftLight: {
                        for (int i = 0; i < size; ++i) {
                            int temp;
                            if (fastBitmap.getRed(i) < 128) {
                                temp = 2 * this.overlay.getRed(i) * fastBitmap.getRed(i) / 255;
                                temp = Math.min(255, temp);
                                fastBitmap.setRed(i, temp);
                            } else {
                                temp = 255 - 2 * (255 - this.overlay.getRed(i)) * (255 - fastBitmap.getRed(i)) / 255;
                                temp = Math.min(255, temp);
                                fastBitmap.setRed(i, temp);
                            }
                            if (fastBitmap.getGreen(i) < 128) {
                                temp = 2 * this.overlay.getGreen(i) * fastBitmap.getGreen(i) / 255;
                                temp = Math.min(255, temp);
                                fastBitmap.setGreen(i, temp);
                            } else {
                                temp = 255 - 2 * (255 - this.overlay.getGreen(i)) * (255 - fastBitmap.getGreen(i)) / 255;
                                temp = Math.min(255, temp);
                                fastBitmap.setGreen(i, temp);
                            }
                            if (fastBitmap.getBlue(i) < 128) {
                                temp = 2 * this.overlay.getBlue(i) * fastBitmap.getBlue(i) / 255;
                                temp = Math.min(255, temp);
                                fastBitmap.setBlue(i, temp);
                                continue;
                            }
                            temp = 255 - 2 * (255 - this.overlay.getBlue(i)) * (255 - fastBitmap.getBlue(i)) / 255;
                            temp = Math.min(255, temp);
                            fastBitmap.setBlue(i, temp);
                        }
                        break block116;
                    }
                    case HardLight: {
                        for (int i = 0; i < size; ++i) {
                            float temp;
                            if (this.overlay.getRed(i) < 128) {
                                temp = (float)(2 * ((fastBitmap.getRed(i) >> 1) + 64)) * ((float)this.overlay.getRed(i) / 255.0f);
                                fastBitmap.setRed(i, (int)temp);
                            } else {
                                temp = 255.0f - (float)(2 * (255 - ((fastBitmap.getRed(i) >> 1) + 64))) * (float)(255 - this.overlay.getRed(i)) / 255.0f;
                                fastBitmap.setRed(i, (int)temp);
                            }
                            if (this.overlay.getGreen(i) < 128) {
                                temp = (float)(2 * ((fastBitmap.getGreen(i) >> 1) + 64)) * ((float)this.overlay.getGreen(i) / 255.0f);
                                fastBitmap.setGreen(i, (int)temp);
                            } else {
                                temp = 255.0f - (float)(2 * (255 - ((fastBitmap.getGreen(i) >> 1) + 64))) * (float)(255 - this.overlay.getGreen(i)) / 255.0f;
                                fastBitmap.setGreen(i, (int)temp);
                            }
                            if (this.overlay.getBlue(i) < 128) {
                                temp = (float)(2 * ((fastBitmap.getBlue(i) >> 1) + 64)) * ((float)this.overlay.getBlue(i) / 255.0f);
                                fastBitmap.setBlue(i, (int)temp);
                                continue;
                            }
                            temp = 255.0f - (float)(2 * (255 - ((fastBitmap.getBlue(i) >> 1) + 64))) * (float)(255 - this.overlay.getBlue(i)) / 255.0f;
                            fastBitmap.setBlue(i, (int)temp);
                        }
                        break block116;
                    }
                    case ColorDodge: {
                        for (int i = 0; i < size; ++i) {
                            int x;
                            if (this.overlay.getRed(i) == 255) {
                                fastBitmap.setRed(i, 255);
                            } else {
                                x = Math.min(255, (fastBitmap.getRed(i) << 8) / (255 - this.overlay.getRed(i)));
                                fastBitmap.setRed(i, x);
                            }
                            if (this.overlay.getGreen(i) == 255) {
                                fastBitmap.setGreen(i, 255);
                            } else {
                                x = Math.min(255, (fastBitmap.getGreen(i) << 8) / (255 - this.overlay.getGreen(i)));
                                fastBitmap.setGreen(i, x);
                            }
                            if (this.overlay.getBlue(i) == 255) {
                                fastBitmap.setBlue(i, 255);
                                continue;
                            }
                            x = Math.min(255, (fastBitmap.getBlue(i) << 8) / (255 - this.overlay.getBlue(i)));
                            fastBitmap.setBlue(i, x);
                        }
                        break block116;
                    }
                    case ColorBurn: {
                        for (int i = 0; i < size; ++i) {
                            int x;
                            if (this.overlay.getRed(i) == 0) {
                                fastBitmap.setRed(i, this.overlay.getRed(i));
                            } else {
                                x = Math.max(0, 255 - (255 - fastBitmap.getRed(i) << 8) / this.overlay.getRed(i));
                                fastBitmap.setRed(i, x);
                            }
                            if (this.overlay.getGreen(i) == 0) {
                                fastBitmap.setGreen(i, this.overlay.getGreen(i));
                            } else {
                                x = Math.max(0, 255 - (255 - fastBitmap.getGreen(i) << 8) / this.overlay.getGreen(i));
                                fastBitmap.setGreen(i, x);
                            }
                            if (this.overlay.getBlue(i) == 0) {
                                fastBitmap.setBlue(i, this.overlay.getBlue(i));
                                continue;
                            }
                            x = Math.max(0, 255 - (255 - fastBitmap.getBlue(i) << 8) / this.overlay.getBlue(i));
                            fastBitmap.setBlue(i, x);
                        }
                        break block116;
                    }
                    case LinearLight: {
                        for (int i = 0; i < size; ++i) {
                            int x;
                            int temp;
                            if (this.overlay.getRed(i) < 128) {
                                temp = fastBitmap.getRed(i) + 2 * this.overlay.getRed(i);
                                if (temp < 255) {
                                    fastBitmap.setRed(i, 0);
                                } else {
                                    fastBitmap.setRed(i, temp - 255);
                                }
                            } else {
                                x = Math.min(fastBitmap.getRed(i) + 2 * (this.overlay.getRed(i) - 128), 255);
                                fastBitmap.setRed(i, x);
                            }
                            if (this.overlay.getGreen(i) < 128) {
                                temp = fastBitmap.getGreen(i) + 2 * this.overlay.getGreen(i);
                                if (temp < 255) {
                                    fastBitmap.setGreen(i, 0);
                                } else {
                                    fastBitmap.setGreen(i, temp - 255);
                                }
                            } else {
                                x = Math.min(fastBitmap.getGreen(i) + 2 * (this.overlay.getGreen(i) - 128), 255);
                                fastBitmap.setGreen(i, x);
                            }
                            if (this.overlay.getBlue(i) < 128) {
                                temp = fastBitmap.getBlue(i) + 2 * this.overlay.getBlue(i);
                                if (temp < 255) {
                                    fastBitmap.setBlue(i, 0);
                                    continue;
                                }
                                fastBitmap.setBlue(i, temp - 255);
                                continue;
                            }
                            x = Math.min(fastBitmap.getBlue(i) + 2 * (this.overlay.getBlue(i) - 128), 255);
                            fastBitmap.setBlue(i, x);
                        }
                        break block116;
                    }
                    case VividLight: {
                        for (int i = 0; i < size; ++i) {
                            int x;
                            int o;
                            if (this.overlay.getRed(i) < 128) {
                                o = this.overlay.getRed(i) * 2;
                                if (o == 0) {
                                    fastBitmap.setRed(i, o);
                                } else {
                                    x = Math.max(0, 255 - (255 - fastBitmap.getRed(i) << 8) / o);
                                    fastBitmap.setRed(i, x);
                                }
                            } else {
                                o = 2 * (this.overlay.getRed(i) - 128);
                                if (o == 255) {
                                    fastBitmap.setRed(i, 255);
                                } else {
                                    x = Math.min(255, (fastBitmap.getRed(i) << 8) / (255 - o));
                                    fastBitmap.setRed(i, x);
                                }
                            }
                            if (this.overlay.getGreen(i) < 128) {
                                o = this.overlay.getGreen(i) * 2;
                                if (o == 0) {
                                    fastBitmap.setGreen(i, o);
                                } else {
                                    x = Math.max(0, 255 - (255 - fastBitmap.getGreen(i) << 8) / o);
                                    fastBitmap.setGreen(i, x);
                                }
                            } else {
                                o = 2 * (this.overlay.getGreen(i) - 128);
                                if (o == 255) {
                                    fastBitmap.setGreen(i, 255);
                                } else {
                                    x = Math.min(255, (fastBitmap.getGreen(i) << 8) / (255 - o));
                                    fastBitmap.setGreen(i, x);
                                }
                            }
                            if (this.overlay.getBlue(i) < 128) {
                                o = this.overlay.getBlue(i) * 2;
                                if (o == 0) {
                                    fastBitmap.setBlue(i, o);
                                    continue;
                                }
                                x = Math.max(0, 255 - (255 - fastBitmap.getBlue(i) << 8) / o);
                                fastBitmap.setBlue(i, x);
                                continue;
                            }
                            o = 2 * (this.overlay.getBlue(i) - 128);
                            if (o == 255) {
                                fastBitmap.setGreen(i, 255);
                                continue;
                            }
                            x = Math.min(255, (fastBitmap.getBlue(i) << 8) / (255 - o));
                            fastBitmap.setBlue(i, x);
                        }
                        break block116;
                    }
                    case PinLight: {
                        for (int i = 0; i < size; ++i) {
                            int o = this.overlay.getRed(i) * 2;
                            if (this.overlay.getRed(i) < 128) {
                                if (o < fastBitmap.getRed(i)) {
                                    fastBitmap.setRed(i, o);
                                }
                            } else if (o > fastBitmap.getRed(i)) {
                                fastBitmap.setRed(i, o);
                            }
                            o = this.overlay.getGreen(i) * 2;
                            if (this.overlay.getGreen(i) < 128) {
                                if (o < fastBitmap.getGreen(i)) {
                                    fastBitmap.setGreen(i, o);
                                }
                            } else if (o > fastBitmap.getGreen(i)) {
                                fastBitmap.setGreen(i, o);
                            }
                            o = this.overlay.getBlue(i) * 2;
                            if (this.overlay.getBlue(i) < 128) {
                                if (o >= fastBitmap.getBlue(i)) continue;
                                fastBitmap.setBlue(i, o);
                                continue;
                            }
                            if (o <= fastBitmap.getBlue(i)) continue;
                            fastBitmap.setBlue(i, o);
                        }
                        break block116;
                    }
                    case Reflect: {
                        for (int i = 0; i < size; ++i) {
                            int x;
                            if (this.overlay.getRed(i) == 255) {
                                fastBitmap.setRed(i, 255);
                            } else {
                                x = Math.min(255, fastBitmap.getRed(i) * fastBitmap.getRed(i) / (255 - this.overlay.getRed(i)));
                                fastBitmap.setRed(i, x);
                            }
                            if (this.overlay.getGreen(i) == 255) {
                                fastBitmap.setGreen(i, 255);
                            } else {
                                x = Math.min(255, fastBitmap.getGreen(i) * fastBitmap.getGreen(i) / (255 - this.overlay.getGreen(i)));
                                fastBitmap.setGreen(i, x);
                            }
                            if (this.overlay.getBlue(i) == 255) {
                                fastBitmap.setBlue(i, 255);
                                continue;
                            }
                            x = Math.min(255, fastBitmap.getBlue(i) * fastBitmap.getBlue(i) / (255 - this.overlay.getBlue(i)));
                            fastBitmap.setBlue(i, x);
                        }
                        break block116;
                    }
                    case Phoenix: {
                        for (int i = 0; i < size; ++i) {
                            int r = Math.min(fastBitmap.getRed(i), this.overlay.getRed(i)) - Math.max(fastBitmap.getRed(i), this.overlay.getRed(i)) + 255;
                            int g = Math.min(fastBitmap.getGreen(i), this.overlay.getGreen(i)) - Math.max(fastBitmap.getGreen(i), this.overlay.getGreen(i)) + 255;
                            int b = Math.min(fastBitmap.getBlue(i), this.overlay.getBlue(i)) - Math.max(fastBitmap.getBlue(i), this.overlay.getBlue(i)) + 255;
                            fastBitmap.setRGB(i, r, g, b);
                        }
                        break;
                    }
                }
                break block116;
            }
            throw new IllegalArgumentException("Blend only works in RGB images.");
        }
    }

    public static enum Algorithm {
        Lighten,
        Darken,
        Multiply,
        Average,
        Add,
        Subtract,
        Difference,
        Negation,
        Screen,
        Exclusion,
        Overlay,
        SoftLight,
        HardLight,
        ColorDodge,
        ColorBurn,
        LinearLight,
        VividLight,
        PinLight,
        Reflect,
        Phoenix;

    }
}

