/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.IntRange;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class AdditiveNoise
implements IApplyInPlace {
    private int min = -10;
    private int max = 10;

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public AdditiveNoise() {
    }

    public AdditiveNoise(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public AdditiveNoise(IntRange range) {
        this.min = range.getMin();
        this.max = range.getMax();
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                int g = fastBitmap.getGray(i);
                g = Math.min(255, Math.max(0, g + this.generateNumber(this.min, this.max)));
                fastBitmap.setGray(i, g);
            }
        } else if (fastBitmap.isRGB()) {
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                int r = fastBitmap.getRed(i);
                int g = fastBitmap.getGreen(i);
                int b = fastBitmap.getBlue(i);
                r = Math.min(255, Math.max(0, r + this.generateNumber(this.min, this.max)));
                g = Math.min(255, Math.max(0, g + this.generateNumber(this.min, this.max)));
                b = Math.min(255, Math.max(0, b + this.generateNumber(this.min, this.max)));
                fastBitmap.setRGB(i, r, g, b);
            }
        } else {
            throw new IllegalArgumentException("Additive Noise only supports Grayscale and RGB images.");
        }
    }

    private int generateNumber(int min, int max) {
        return Math.min(min, max) + (int)Math.round(-0.5 + (double)(1 + Math.abs(min - max)) * Math.random());
    }
}

