/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Corners;

import Catalano.Imaging.Corners.Fast12;
import Catalano.Imaging.Corners.Fast9;
import Catalano.Imaging.Corners.FeaturePoint;
import Catalano.Imaging.Corners.ICornersFeatureDetector;
import Catalano.Imaging.FastBitmap;
import java.util.List;

public class FastCornersDetector
implements ICornersFeatureDetector {
    private int threshold = 20;
    private boolean suppress = true;
    private Algorithm algorithm = Algorithm.FAST_9;

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public boolean isSuppressed() {
        return this.suppress;
    }

    public void setSuppression(boolean suppress) {
        this.suppress = suppress;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public FastCornersDetector() {
    }

    public FastCornersDetector(int threshold) {
        this.threshold = threshold;
    }

    public FastCornersDetector(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public FastCornersDetector(int threshold, boolean suppress) {
        this.threshold = threshold;
        this.suppress = suppress;
    }

    public FastCornersDetector(int threshold, boolean suppress, Algorithm algorithm) {
        this.threshold = threshold;
        this.suppress = suppress;
        this.algorithm = algorithm;
    }

    @Override
    public List<FeaturePoint> ProcessImage(FastBitmap fastBitmap) {
        switch (this.algorithm) {
            case FAST_9: {
                Fast9 fast9 = new Fast9(this.threshold, this.suppress);
                return fast9.ProcessImage(fastBitmap);
            }
            case FAST_12: {
                Fast12 fast12 = new Fast12(this.threshold, this.suppress);
                return fast12.ProcessImage(fastBitmap);
            }
        }
        return null;
    }

    public static enum Algorithm {
        FAST_9,
        FAST_12;

    }
}

