/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class HysteresisThreshold
implements IApplyInPlace {
    int lowThreshold = 20;
    int highThreshold = 100;

    public int getLowThreshold() {
        return this.lowThreshold;
    }

    public void setLowThreshold(int lowThreshold) {
        this.lowThreshold = lowThreshold;
    }

    public int getHighThreshold() {
        return this.highThreshold;
    }

    public void setHighThreshold(int highThreshold) {
        this.highThreshold = highThreshold;
    }

    public HysteresisThreshold() {
    }

    public HysteresisThreshold(int lowThreshold, int highThreshold) {
        this.lowThreshold = lowThreshold;
        this.highThreshold = highThreshold;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Hysteresis Threshold only works with grayscale images.");
        }
        this.Parallel(fastBitmap);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        int processors = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[processors];
        int part = fastBitmap.getHeight() / processors;
        int last = processors - 1;
        int startX = 1;
        for (i = 0; i < processors; ++i) {
            if (last == i) {
                part = fastBitmap.getHeight() - startX - 1;
            }
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, 1, fastBitmap.getWidth() - 1, startX + part)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < processors; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            for (int i = this.share.startX; i < this.share.endHeight; ++i) {
                for (int j = this.share.startY; j < this.share.endWidth; ++j) {
                    if (this.share.fastBitmap.getGray(i, j) >= HysteresisThreshold.this.highThreshold) continue;
                    if (this.share.fastBitmap.getGray(i, j) < HysteresisThreshold.this.lowThreshold) {
                        this.share.fastBitmap.setGray(i, j, 0);
                        continue;
                    }
                    if (this.share.fastBitmap.getGray(i, j - 1) >= HysteresisThreshold.this.highThreshold || this.share.fastBitmap.getGray(i, j + 1) >= HysteresisThreshold.this.highThreshold || this.share.fastBitmap.getGray(i - 1, j - 1) >= HysteresisThreshold.this.highThreshold || this.share.fastBitmap.getGray(i - 1, j) >= HysteresisThreshold.this.highThreshold || this.share.fastBitmap.getGray(i - 1, j + 1) >= HysteresisThreshold.this.highThreshold || this.share.fastBitmap.getGray(i + 1, j - 1) >= HysteresisThreshold.this.highThreshold || this.share.fastBitmap.getGray(i + 1, j) >= HysteresisThreshold.this.highThreshold || this.share.fastBitmap.getGray(i + 1, j + 1) >= HysteresisThreshold.this.highThreshold) continue;
                    this.share.fastBitmap.setGray(i, j, 0);
                }
            }
        }
    }
}

