/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class FastVariance
implements IApplyInPlace {
    private int radius = 2;
    private FastBitmap copy;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public FastVariance() {
    }

    public FastVariance(int radius) {
        this.setRadius(radius);
    }

    @Override
    public void applyInPlace(FastBitmap fb) {
        int i;
        this.copy = new FastBitmap(fb);
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fb.getHeight() / cores;
        int last = cores - 1;
        boolean lastThread = false;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            if (i == last) {
                lastThread = true;
            }
            t[i] = new Thread(new CThread(new Share(fb, startX, startX += part, lastThread)));
            t[i].start();
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class CThread
    implements Runnable {
        private Share share;

        public CThread(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            int safe = FastVariance.this.radius;
            if (this.share.lastThread) {
                safe = 0;
                this.share.endHeight = this.share.fastBitmap.getHeight();
            }
            if (this.share.fastBitmap.isGrayscale()) {
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int n = 0;
                        double mean = 0.0;
                        double m2 = 0.0;
                        for (int i = x - FastVariance.this.radius; i <= x + FastVariance.this.radius; ++i) {
                            for (int j = y - FastVariance.this.radius; j <= y + FastVariance.this.radius; ++j) {
                                if (i < 0 || i >= this.share.endHeight + safe || j < 0 || j >= this.share.fastBitmap.getWidth()) continue;
                                double delta = (double)FastVariance.this.copy.getGray(i, j) - mean;
                                m2 += delta * ((double)FastVariance.this.copy.getGray(i, j) - (mean += delta / (double)(++n)));
                            }
                        }
                        double var = m2 / (double)(n - 1);
                        if (var < 0.0) {
                            var = 0.0;
                        }
                        if (var > 255.0) {
                            var = 255.0;
                        }
                        this.share.fastBitmap.setGray(x, y, (int)var);
                    }
                }
            } else {
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int n = 0;
                        double meanR = 0.0;
                        double meanG = 0.0;
                        double meanB = 0.0;
                        double m2R = 0.0;
                        double m2G = 0.0;
                        double m2B = 0.0;
                        for (int i = x - FastVariance.this.radius; i <= x + FastVariance.this.radius; ++i) {
                            for (int j = y - FastVariance.this.radius; j <= y + FastVariance.this.radius; ++j) {
                                if (i < 0 || i >= this.share.endHeight + safe || j < 0 || j >= this.share.fastBitmap.getWidth()) continue;
                                double deltaR = (double)FastVariance.this.copy.getRed(i, j) - meanR;
                                double deltaG = (double)FastVariance.this.copy.getGreen(i, j) - meanG;
                                double deltaB = (double)FastVariance.this.copy.getBlue(i, j) - meanB;
                                m2R += deltaR * ((double)FastVariance.this.copy.getRed(i, j) - (meanR += deltaR / (double)(++n)));
                                m2G += deltaG * ((double)FastVariance.this.copy.getGreen(i, j) - (meanG += deltaG / (double)n));
                                m2B += deltaB * ((double)FastVariance.this.copy.getBlue(i, j) - (meanB += deltaB / (double)n));
                            }
                        }
                        double varR = m2R / (double)(n - 1);
                        double varG = m2G / (double)(n - 1);
                        double varB = m2B / (double)(n - 1);
                        if (varR < 0.0) {
                            varR = 0.0;
                        }
                        if (varG < 0.0) {
                            varG = 0.0;
                        }
                        if (varB < 0.0) {
                            varB = 0.0;
                        }
                        if (varR > 255.0) {
                            varR = 255.0;
                        }
                        if (varG > 255.0) {
                            varG = 255.0;
                        }
                        if (varB > 255.0) {
                            varB = 255.0;
                        }
                        this.share.fastBitmap.setRGB(x, y, (int)varR, (int)varG, (int)varB);
                    }
                }
            }
        }
    }
}

