/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Erosion
implements IApplyInPlace {
    private int radius = 0;
    private int[][] kernel;
    FastBitmap copy;

    public Erosion() {
        this.radius = 1;
    }

    public Erosion(int radius) {
        this.radius = Math.max(radius, 1);
    }

    public Erosion(int[][] kernel) {
        this.kernel = kernel;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        this.copy = new FastBitmap(fastBitmap);
        if (this.kernel == null) {
            this.createKernel(this.radius);
        }
        this.Parallel(fastBitmap);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fastBitmap.getHeight() / cores;
        int last = cores - 1;
        boolean lastThread = false;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            if (i == last) {
                lastThread = true;
            }
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, startX + part, lastThread)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void createKernel(int radius) {
        int size = radius * 2 + 1;
        this.kernel = new int[size][size];
        for (int i = 0; i < this.kernel.length; ++i) {
            for (int j = 0; j < this.kernel[0].length; ++j) {
                this.kernel[i][j] = 1;
            }
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            int safe;
            if (this.share.fastBitmap.isGrayscale()) {
                if (Erosion.this.kernel == null) {
                    Erosion.this.createKernel(Erosion.this.radius);
                }
                safe = Erosion.this.radius;
                if (this.share.lastThread) {
                    safe = 0;
                }
                for (int i = this.share.startX; i < this.share.endHeight; ++i) {
                    for (int j = 0; j < this.share.fastBitmap.getWidth(); ++j) {
                        int X = 0;
                        int min = 255;
                        for (int x = i - Erosion.this.radius; x < i + Erosion.this.radius + 1; ++x) {
                            int Y = 0;
                            for (int y = j - Erosion.this.radius; y < j + Erosion.this.radius + 1; ++y) {
                                int val;
                                if (x >= 0 && x < this.share.endHeight + safe && y >= 0 && y < this.share.fastBitmap.getWidth() && (val = Erosion.this.copy.getGray(x, y) - Erosion.this.kernel[X][Y]) < min) {
                                    min = val;
                                }
                                ++Y;
                            }
                            ++X;
                        }
                        min = min < 0 ? 0 : min;
                        this.share.fastBitmap.setGray(i, j, min);
                    }
                }
            }
            if (this.share.fastBitmap.isRGB()) {
                if (Erosion.this.kernel == null) {
                    Erosion.this.createKernel(Erosion.this.radius);
                }
                safe = Erosion.this.radius;
                if (this.share.lastThread) {
                    safe = 0;
                }
                for (int i = this.share.startX; i < this.share.endHeight; ++i) {
                    for (int j = 0; j < this.share.fastBitmap.getWidth(); ++j) {
                        int X = 0;
                        int minB = 255;
                        int minG = 255;
                        int minR = 255;
                        for (int x = i - Erosion.this.radius; x < i + Erosion.this.radius + 1; ++x) {
                            int Y = 0;
                            for (int y = j - Erosion.this.radius; y < j + Erosion.this.radius + 1; ++y) {
                                if (x >= 0 && x < this.share.endHeight + safe && y >= 0 && y < this.share.fastBitmap.getWidth()) {
                                    int valR = Erosion.this.copy.getRed(x, y) - Erosion.this.kernel[X][Y];
                                    int valG = Erosion.this.copy.getGreen(x, y) - Erosion.this.kernel[X][Y];
                                    int valB = Erosion.this.copy.getBlue(x, y) - Erosion.this.kernel[X][Y];
                                    if (valR < minR) {
                                        minR = valR;
                                    }
                                    if (valG < minG) {
                                        minG = valG;
                                    }
                                    if (valB < minB) {
                                        minB = valB;
                                    }
                                }
                                ++Y;
                            }
                            ++X;
                        }
                        minR = minR < 0 ? 0 : minR;
                        minG = minG < 0 ? 0 : minG;
                        minB = minB < 0 ? 0 : minB;
                        this.share.fastBitmap.setRGB(i, j, minR, minG, minB);
                    }
                }
            }
        }
    }
}

