/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Core.IntRange;
import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class ColorFiltering
implements IApplyInPlace {
    private IntRange red;
    private IntRange green;
    private IntRange blue;

    public ColorFiltering() {
    }

    public ColorFiltering(IntRange red, IntRange green, IntRange blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isRGB()) {
            throw new IllegalArgumentException("Color Filtering only works in RGB images.");
        }
        this.Parallel(fastBitmap);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fastBitmap.getHeight() / cores;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, startX + part)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                    int r = this.share.fastBitmap.getRed(x, y);
                    int g = this.share.fastBitmap.getGreen(x, y);
                    int b = this.share.fastBitmap.getBlue(x, y);
                    if (r >= ColorFiltering.this.red.getMin() && r <= ColorFiltering.this.red.getMax() && g >= ColorFiltering.this.green.getMin() && g <= ColorFiltering.this.green.getMax() && b >= ColorFiltering.this.blue.getMin() && b <= ColorFiltering.this.blue.getMax()) {
                        this.share.fastBitmap.setRGB(x, y, r, g, b);
                        continue;
                    }
                    this.share.fastBitmap.setRGB(x, y, 0, 0, 0);
                }
            }
        }
    }
}

